/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilderFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.CallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.QueryFactoryImpl;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;

public class QueryModule {
    private final CallableQueryFactory artQueryFactory;
    private final BranchCriteriaFactory branchCriteriaFactory;
    private final TransactionCriteriaFactory txCriteriaFactory;
    private final TupleQuery tupleQuery;
    private final ApplicabilityDsQuery applicabilityDsQuery;
    private final QueryEngine queryEngine;
    private final OrcsTokenService tokenService;
    private final OrcsApi orcsApi;

    public QueryModule(OrcsApi orcsApi, Log logger, QueryEngine queryEngine, GraphBuilderFactory builderFactory, GraphProvider provider, OrcsTokenService tokenService, ExternalArtifactManager proxyManager) {
        this.orcsApi = orcsApi;
        this.queryEngine = queryEngine;
        this.artQueryFactory = new CallableQueryFactory(logger, queryEngine, builderFactory, provider, proxyManager);
        this.branchCriteriaFactory = new BranchCriteriaFactory();
        this.txCriteriaFactory = new TransactionCriteriaFactory();
        this.tupleQuery = queryEngine.createTupleQuery();
        this.applicabilityDsQuery = queryEngine.createApplicabilityDsQuery();
        this.tokenService = tokenService;
    }

    public QueryFactory createQueryFactory(OrcsSession session) {
        return new QueryFactoryImpl(this.orcsApi, this.artQueryFactory, this.branchCriteriaFactory, this.txCriteriaFactory, this.tupleQuery, this.applicabilityDsQuery, this.queryEngine, this.tokenService);
    }

    public CallableQueryFactory getArtQueryFactory() {
        return this.artQueryFactory;
    }

    public static interface QueryModuleProvider {
        public QueryFactory getQueryFactory(OrcsSession var1);
    }
}

