/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model;

import org.eclipse.osee.framework.jdk.core.type.FullyNamed;
import org.eclipse.osee.framework.jdk.core.type.HasDescription;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class OseeEnumEntry
implements FullyNamed,
HasDescription {
    private int ordinal;
    private String description;
    private String name;

    public OseeEnumEntry(String name, int ordinal, String description) {
        this.name = name;
        this.ordinal = ordinal;
        this.description = description;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public Pair<String, Integer> asPair() {
        return new Pair((Object)this.getName(), (Object)this.ordinal());
    }

    public boolean equals(Object object) {
        if (object instanceof OseeEnumEntry) {
            OseeEnumEntry other = (OseeEnumEntry)object;
            return super.equals(other) && this.ordinal() == other.ordinal();
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + this.ordinal();
        return result;
    }

    public String toString() {
        return String.format("%s:%s%s", this.getName(), this.ordinal(), this.toStringDescription());
    }

    private String toStringDescription() {
        String description = "";
        if (Strings.isValid((String)this.getDescription())) {
            description = " - " + this.getDescription();
        }
        return description;
    }

    public String getName() {
        return this.name;
    }
}

