/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.internal.InterfaceStructureAccessor;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfaceStructureApiImpl
implements InterfaceStructureApi {
    private ArtifactAccessor<InterfaceStructureToken> accessor;
    private final InterfacePlatformTypeApi interfacePlatformTypeApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfaceElementArrayApi interfaceElementArrayApi;
    private final List<AttributeTypeId> structureAttributeList;
    private final List<AttributeTypeId> elementAttributeList;

    InterfaceStructureApiImpl(OrcsApi orcsApi, InterfacePlatformTypeApi interfacePlatformTypeApi, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi) {
        this.setAccessor(new InterfaceStructureAccessor(orcsApi));
        this.interfacePlatformTypeApi = interfacePlatformTypeApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfaceElementArrayApi = interfaceElementArrayApi;
        this.structureAttributeList = this.createStructureAttributeList();
        this.elementAttributeList = this.createElementAttributeList();
    }

    private ArtifactAccessor<InterfaceStructureToken> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceStructureToken> accessor) {
        this.accessor = accessor;
    }

    private List<AttributeTypeId> createStructureAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceStructureCategory);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMinSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMaxSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceTaskFileType);
        return attributes;
    }

    private List<AttributeTypeId> createElementAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Notes);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementAlterable);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexEnd);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexStart);
        return attributes;
    }

    private InterfaceStructureElementToken defaultSetUpElement(InterfaceStructureElementToken element) {
        return this.defaultSetUpElement(element, InterfaceStructureElementToken.SENTINEL);
    }

    private InterfaceStructureElementToken defaultSetUpElement(InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement) {
        if (previousElement.isInvalid() && !previousElement.isAutogenerated()) {
            element.setBeginByte(0.0);
            element.setBeginWord(0.0);
        } else {
            element.setBeginByte((previousElement.getEndByte() + 1.0) % 4.0);
            element.setBeginWord(Math.floor((previousElement.getEndWord() * 4.0 + previousElement.getEndByte() + 1.0) / 4.0));
        }
        return element;
    }

    private InterfaceStructureToken parseStructure(BranchId branch, InterfaceStructureToken structure) {
        return this.parseStructure(branch, structure, new LinkedList<InterfaceStructureElementToken>());
    }

    private InterfaceStructureToken parseStructure(BranchId branch, InterfaceStructureToken structure, String elementFilter) {
        return this.parseStructure(branch, structure, this.interfaceElementApi.getAllRelatedAndFilter(branch, ArtifactId.valueOf((Long)structure.getId()), elementFilter));
    }

    private InterfaceStructureToken parseStructure(BranchId branch, InterfaceStructureToken structure, List<InterfaceStructureElementToken> defaultElements) {
        try {
            LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
            elements.addAll(defaultElements.size() > 0 ? defaultElements : this.interfaceElementApi.getAllRelated(branch, ArtifactId.valueOf((Long)structure.getId())));
            LinkedList<InterfaceStructureElementToken> tempElements = new LinkedList<InterfaceStructureElementToken>();
            if (elements.size() >= 2) {
                Iterator elementIterator = elements.iterator();
                InterfaceStructureElementToken previousElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                InterfaceStructureElementToken currentElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                previousElement.setBeginByte(0.0);
                previousElement.setBeginWord(0.0);
                tempElements.add(previousElement);
                if (!elementIterator.hasNext()) {
                    currentElement = this.defaultSetUpElement(currentElement, previousElement);
                }
                while (elementIterator.hasNext()) {
                    InterfaceStructureElementToken nextElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                    if ((currentElement = this.defaultSetUpElement(currentElement, previousElement)).getInterfacePlatformTypeByteSize() >= 4.0) {
                        if (previousElement.getEndByte() != 3.0) {
                            previousElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", (previousElement.getEndByte() + 1.0) % 4.0, Math.floor((previousElement.getEndWord() * 4.0 + previousElement.getEndByte() + 1.0) / 4.0), (int)Math.floor(3.0 - previousElement.getEndByte()), true);
                            tempElements.add(previousElement);
                        }
                        if (currentElement.getInterfacePlatformTypeWordSize() > 1.0 && (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize() != 0.0) {
                            previousElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for byte alignment", (previousElement.getEndByte() + 1.0) % 4.0, Math.floor((previousElement.getEndWord() * 4.0 + previousElement.getEndByte() + 1.0) / 4.0), (int)(Math.floor(currentElement.getInterfacePlatformTypeWordSize() - (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize()) * 4.0) - 1);
                            tempElements.add(previousElement);
                        }
                        currentElement = this.defaultSetUpElement(currentElement, previousElement);
                    }
                    tempElements.add(currentElement);
                    previousElement = currentElement;
                    currentElement = nextElement;
                }
                if ((currentElement = this.defaultSetUpElement(currentElement, previousElement)).getInterfacePlatformTypeByteSize() >= 4.0) {
                    if (previousElement.getEndByte() != 3.0) {
                        previousElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", (previousElement.getEndByte() + 1.0) % 4.0, Math.floor((previousElement.getEndWord() * 4.0 + previousElement.getEndByte() + 1.0) / 4.0), (int)Math.floor(3.0 - previousElement.getEndByte()), true);
                        tempElements.add(previousElement);
                    }
                    if (currentElement.getInterfacePlatformTypeWordSize() > 1.0 && (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize() != 0.0) {
                        previousElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for byte alignment", (previousElement.getEndByte() + 1.0) % 4.0, Math.floor((previousElement.getEndWord() * 4.0 + previousElement.getEndByte() + 1.0) / 4.0), (int)(Math.floor(currentElement.getInterfacePlatformTypeWordSize() - (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize()) * 4.0) - 1);
                        tempElements.add(previousElement);
                    }
                    currentElement = this.defaultSetUpElement(currentElement, previousElement);
                }
                tempElements.add(currentElement);
                if (currentElement.getEndByte() != 3.0) {
                    tempElements.add(new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", (currentElement.getEndWord() * 4.0 + currentElement.getEndByte() + 1.0) % 4.0, Math.floor((currentElement.getEndWord() * 4.0 + currentElement.getEndByte() + 1.0) / 4.0), (int)Math.floor(3.0 - currentElement.getEndByte()), true));
                }
                if (currentElement.getEndWord() % 2.0 != 1.0) {
                    currentElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for byte alignment", (currentElement.getEndWord() * 4.0 + currentElement.getEndByte() + 1.0) % 4.0, Math.floor((currentElement.getEndWord() * 4.0 + currentElement.getEndByte() + 1.0) / 4.0), 4);
                    tempElements.add(currentElement);
                }
                structure.setElements(tempElements);
            } else {
                InterfaceStructureElementToken lastElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", 0.0, 0.0, 0);
                for (InterfaceStructureElementToken element : elements) {
                    element.setBeginByte(0.0);
                    element.setBeginWord(0.0);
                    PlatformTypeToken currentPlatformType = this.interfacePlatformTypeApi.getAccessor().getByRelationWithoutId(branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    element.setPlatformTypeId(currentPlatformType.getId());
                    element.setPlatformTypeName(currentPlatformType.getName());
                    element.setInterfacePlatformTypeBitSize(currentPlatformType.getInterfacePlatformTypeBitSize());
                    element.setLogicalType(currentPlatformType.getInterfaceLogicalType() != null ? currentPlatformType.getInterfaceLogicalType() : "");
                    element.setInterfacePlatformTypeMinval(currentPlatformType.getInterfacePlatformTypeMinval() != null ? currentPlatformType.getInterfacePlatformTypeMinval() : "");
                    element.setInterfacePlatformTypeMaxval(currentPlatformType.getInterfacePlatformTypeMaxval() != null ? currentPlatformType.getInterfacePlatformTypeMaxval() : "");
                    element.setInterfacePlatformTypeDefaultValue(currentPlatformType.getInterfacePlatformTypeDefaultValue() != null ? currentPlatformType.getInterfacePlatformTypeDefaultValue() : "");
                    element.setUnits(currentPlatformType.getInterfacePlatformTypeUnits() != null ? currentPlatformType.getInterfacePlatformTypeUnits() : "");
                    lastElement = element;
                }
                tempElements.addAll(elements);
                if (lastElement.getEndByte() != 3.0) {
                    tempElements.add(new InterfaceStructureElementToken("Insert Spare", "byte align spare for aligning to word start", (lastElement.getEndWord() * 4.0 + lastElement.getEndByte() + 1.0) % 4.0, Math.floor((lastElement.getEndWord() * 4.0 + lastElement.getEndByte() + 1.0) / 4.0), (int)Math.floor(3.0 - lastElement.getEndByte()), true));
                }
                if (lastElement.getEndWord() % 2.0 != 1.0) {
                    lastElement = new InterfaceStructureElementToken("Insert Spare", "byte align spare for byte alignment", (lastElement.getEndWord() * 4.0 + lastElement.getEndByte() + 1.0) % 4.0, Math.floor((lastElement.getEndWord() * 4.0 + lastElement.getEndByte() + 1.0) / 4.0), 4);
                    tempElements.add(lastElement);
                }
                structure.setElements(tempElements);
            }
        }
        catch (Exception exception) {}
        return structure;
    }

    @Override
    public List<InterfaceStructureToken> getAllRelated(BranchId branch, ArtifactId subMessageId) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(branch, structure);
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAll(BranchId branch) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAll(branch, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(branch, structure);
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAllWithoutRelations(BranchId branch) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAll(branch, InterfaceStructureToken.class);
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public List<InterfaceStructureToken> getFiltered(BranchId branch, String filter) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAllByFilter(branch, filter, this.structureAttributeList, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(branch, structure);
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public List<InterfaceStructureToken> getFilteredWithoutRelations(BranchId branch, String filter) {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.getAccessor().getAllByFilter(branch, filter, this.structureAttributeList, InterfaceStructureToken.class);
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    @Override
    public InterfaceStructureToken getRelated(BranchId branch, ArtifactId subMessageId, ArtifactId structureId) {
        try {
            InterfaceStructureToken structure = this.getAccessor().getByRelation(branch, structureId, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, InterfaceStructureToken.class);
            structure = this.parseStructure(branch, structure);
            return structure;
        }
        catch (Exception ex) {
            System.out.println(ex);
            InterfaceStructureToken structure = new InterfaceStructureToken();
            return structure;
        }
    }

    @Override
    public List<InterfaceStructureToken> getAllRelatedAndFilter(BranchId branch, ArtifactId subMessageId, String filter) {
        List<Object> totalStructureList = new LinkedList();
        try {
            totalStructureList = this.getAllRelated(branch, subMessageId);
            for (InterfaceStructureToken interfaceStructureToken : totalStructureList) {
                InterfaceStructureToken interfaceStructureToken2 = this.parseStructure(branch, interfaceStructureToken);
            }
            List list = (List)this.getAccessor().getAllByRelationAndFilter(branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, filter, this.structureAttributeList, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : list) {
                structure = this.parseStructure(branch, structure);
            }
            List<InterfaceStructureElementToken> elements = this.interfaceElementApi.getFiltered(branch, filter);
            for (InterfaceStructureElementToken element : elements) {
                List subStructureList = (List)this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceStructureContent_DataElement, ArtifactId.valueOf((Long)element.getId()), InterfaceStructureToken.class);
                for (InterfaceStructureToken alternateStructure : subStructureList) {
                    if (totalStructureList.indexOf((Object)alternateStructure) != -1 && ((InterfaceStructureToken)((Object)totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)))).getElements().indexOf((Object)element) != -1) {
                        totalStructureList.set(totalStructureList.indexOf((Object)alternateStructure), (Object)this.parseStructure(branch, (InterfaceStructureToken)((Object)totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure))), ((InterfaceStructureToken)((Object)totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)))).getElements()));
                    }
                    LinkedList<InterfaceStructureElementToken> elementList = new LinkedList<InterfaceStructureElementToken>();
                    elementList.add(element);
                    alternateStructure.setElements(elementList);
                    if (totalStructureList.indexOf((Object)alternateStructure) == -1) continue;
                    InterfaceStructureToken cfr_ignored_0 = (InterfaceStructureToken)((Object)totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)));
                    if (!list.contains((Object)alternateStructure)) {
                        list.add(alternateStructure);
                        continue;
                    }
                    InterfaceStructureToken tempStructure2 = (InterfaceStructureToken)((Object)list.get(list.indexOf((Object)alternateStructure)));
                    list.remove((Object)alternateStructure);
                    tempStructure2.getElements().add(element);
                    list.add(tempStructure2);
                }
            }
            return list;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return totalStructureList;
        }
    }

    @Override
    public InterfaceStructureToken getRelatedAndFilter(BranchId branch, ArtifactId subMessageId, ArtifactId structureId, String filter) {
        try {
            InterfaceStructureToken structure = this.getAccessor().getByRelation(branch, structureId, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessageId, InterfaceStructureToken.class);
            structure = this.parseStructure(branch, structure, filter);
            return structure;
        }
        catch (Exception ex) {
            System.out.println(ex);
            InterfaceStructureToken structure = new InterfaceStructureToken();
            return structure;
        }
    }
}

