/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.ComputedCharacteristic;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class ComputedCharacteristicEnum<T extends EnumToken>
extends ComputedCharacteristic<T> {
    private List<T> enumTokens;

    public ComputedCharacteristicEnum(Long id, String name, TaggerTypeToken taggerType, NamespaceToken namespace, String description, List<AttributeTypeGeneric<T>> typesToCompute, int enumCount) {
        super(id, name, taggerType, namespace, description, typesToCompute);
        this.enumTokens = new ArrayList<T>(enumCount);
    }

    public ComputedCharacteristicEnum<EnumToken> getAsEnumToken() {
        return this;
    }

    public Collection<T> getEnumValues() {
        return java.util.Collections.unmodifiableCollection(this.enumTokens);
    }

    public Set<String> getEnumStrValues() {
        HashSet<String> enumStringValues = new HashSet<String>();
        for (EnumToken enumToken : this.enumTokens) {
            enumStringValues.add(enumToken.getName());
        }
        return enumStringValues;
    }

    public boolean isValidEnum(String enumName) {
        for (EnumToken enumToken : this.enumTokens) {
            if (!enumToken.getName().equals(enumName)) continue;
            return true;
        }
        return false;
    }

    public Long getEnumOrdinal(String enumName) {
        for (EnumToken enumToken : this.enumTokens) {
            if (!enumToken.getName().equals(enumName)) continue;
            return enumToken.getId();
        }
        throw new OseeArgumentException("[%s] is not a valid enum name for [%s]", new Object[]{enumName, this});
    }

    protected void addEnum(T enumeration) {
        int ordinal = enumeration.getIdIntValue();
        while (this.enumTokens.size() <= ordinal) {
            this.enumTokens.add(null);
        }
        this.enumTokens.set(ordinal, enumeration);
    }

    <E extends T> void replaceEnumValues(ComputedCharacteristicEnum<E> attributeType) {
        this.enumTokens = Collections.cast(attributeType.enumTokens);
    }

    @Override
    public boolean isMultiplicityValid(ArtifactTypeToken artifactType) {
        return false;
    }

    @Override
    public T calculate(List<T> computingValues) {
        return null;
    }
}

