/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class RequirementTraceTableParser {
    private static Pattern wtrPattern = Pattern.compile("<w:tr .*?>(.*?)</w:tr>");
    private static Pattern wtcPattern = Pattern.compile("<w:tc>(.*?)</w:tc>");
    private static Pattern wpPattern = Pattern.compile("<w:p .*?>(.*?)</w:p>");
    private static Pattern wtPattern = Pattern.compile("<w:t>(.*?)</w:t>");
    private final XResultData results;
    private final LinkedList<String>[] reqtsArray;
    private final Integer numColumns;
    LinkedList<Pair<String, String>> reqtsTraces = new LinkedList();

    public RequirementTraceTableParser(Integer numColumns, XResultData results) {
        this.numColumns = numColumns;
        this.reqtsArray = new LinkedList[numColumns.intValue()];
        int i = 0;
        while (i < numColumns) {
            this.reqtsArray[i] = new LinkedList();
            ++i;
        }
        this.results = results;
    }

    public String outputTraces() throws IOException {
        String fileLocation = "N/A";
        if (!this.reqtsTraces.isEmpty()) {
            Date d = new Date();
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = String.valueOf(d.toString().replaceAll("[\\s:]", "_")) + ".txt";
            File output = new File(tempDir, fileName);
            StringBuilder generated = new StringBuilder();
            for (Pair pair : this.reqtsTraces) {
                generated.append(String.format("%s<-->%s", pair.getFirst(), pair.getSecond()));
                generated.append("\r\n");
            }
            Lib.writeStringToFile((String)generated.toString(), (File)output);
            fileLocation = output.getPath();
        }
        return fileLocation;
    }

    public Collection<Pair<String, String>> getTraces() {
        return this.reqtsTraces;
    }

    public void handleAppendixATable(String content) {
        Matcher m = wtrPattern.matcher(content);
        boolean first = true;
        while (m.find()) {
            if (!first) {
                String wtrContent = m.group(1);
                this.handleAppendixAContent(wtrContent);
                this.buildRelations();
                this.clearValues();
            }
            first = false;
        }
    }

    private void handleAppendixAContent(String content) {
        Matcher m = wtcPattern.matcher(content);
        int count = 0;
        while (m.find()) {
            String wtcContent = m.group(1);
            this.handleAppendixAParagraph(wtcContent, count);
            ++count;
        }
    }

    private void handleAppendixAParagraph(String content, int level) {
        Matcher m = wpPattern.matcher(content);
        while (m.find()) {
            String wpContent = m.group(1);
            this.handleAppendixAItem(wpContent, level);
        }
    }

    private void handleAppendixAItem(String content, int level) {
        Matcher m = wtPattern.matcher(content);
        while (m.find()) {
            String wtContent = m.group(1);
            if (!Strings.isValid((String)wtContent)) continue;
            this.addToLevel(wtContent, level);
        }
    }

    private void addToLevel(String item, int level) {
        if (level > -1 && level < this.numColumns) {
            this.reqtsArray[level].add(item);
            return;
        }
        throw new OseeCoreException("trace level in trace table is invald", new Object[0]);
    }

    private void buildRelations() {
        int i = 0;
        while (i < this.numColumns - 1) {
            for (String parent : this.reqtsArray[i]) {
                for (String child : this.reqtsArray[i + 1]) {
                    if (!Strings.isValid((String)parent) || !Strings.isValid((String)child)) continue;
                    if (child.contains(",")) {
                        String[] elements;
                        String[] stringArray = elements = child.split("\\s*,\\s*");
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String element = stringArray[n2];
                            if (Strings.isValid((String)element)) {
                                this.reqtsTraces.add((Pair<String, String>)new Pair((Object)parent, (Object)element));
                            }
                            ++n2;
                        }
                        continue;
                    }
                    this.reqtsTraces.add((Pair<String, String>)new Pair((Object)parent, (Object)child));
                }
            }
            ++i;
        }
    }

    private void clearValues() {
        int i = 0;
        while (i < this.numColumns) {
            this.reqtsArray[i].clear();
            ++i;
        }
    }
}

