/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.users.AbstractAtsUserService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsUserServiceServerImpl
extends AbstractAtsUserService {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public String getCurrentUserId() {
        return SystemUser.OseeSystem.getUserId();
    }

    public AtsUser getCurrentUser() {
        return AtsCoreUsers.SYSTEM_USER;
    }

    public AtsUser getCurrentUserNoCache() {
        return this.getCurrentUser();
    }

    private ArtifactReadable getArtifactOrSentinel(ArtifactId artifactId) {
        return (ArtifactReadable)this.getQuery().andId(artifactId).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
    }

    private QueryBuilder getQuery() {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
    }

    public static AtsUser valueOf(ArtifactReadable userArt) {
        AtsUser atsUser = new AtsUser();
        atsUser.setName(userArt.getName());
        atsUser.setStoreObject((ArtifactToken)userArt);
        atsUser.setUserId(userArt.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserId, ""));
        atsUser.setEmail(userArt.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Email, ""));
        atsUser.setActive(((Boolean)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Active, (Object)true)).booleanValue());
        atsUser.setId(userArt.getId());
        atsUser.getLoginIds().addAll(userArt.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.LoginId));
        return atsUser;
    }

    public Collection<AtsUser> getUsers() {
        return this.configurationService.getConfigurations().getUsers();
    }

    public boolean isLoadValid() {
        return true;
    }

    protected AtsUser loadUserByUserId(String userId) {
        ArtifactReadable userArt = (ArtifactReadable)this.getQuery().andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.UserId, userId).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (userArt.isValid()) {
            return AtsUserServiceServerImpl.valueOf(userArt);
        }
        return null;
    }

    protected AtsUser loadUserByUserName(String name) {
        ArtifactReadable userArt = (ArtifactReadable)this.getQuery().andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andNameEquals(name).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (userArt.isValid()) {
            return AtsUserServiceServerImpl.valueOf(userArt);
        }
        return null;
    }

    protected AtsUser loadUserByUserId(Long accountId) {
        AtsUser user = null;
        ArtifactReadable userArt = this.getArtifactOrSentinel(ArtifactId.valueOf((Long)accountId));
        if (userArt.isValid()) {
            user = AtsUserServiceServerImpl.valueOf(userArt);
        }
        return user;
    }

    public AtsUser getUserById(ArtifactId id) {
        ArtifactReadable userArt = null;
        userArt = id instanceof ArtifactReadable ? (ArtifactReadable)id : (ArtifactReadable)this.getQuery().andId(id).getResults().getExactlyOne();
        return AtsUserServiceServerImpl.valueOf(userArt);
    }

    public void setCurrentUser(AtsUser user) {
    }

    public void clearCaches() {
    }

    public boolean isAtsAdmin() {
        return this.orcsApi.userService().isInUserGroup(new IUserGroupArtifactToken[]{AtsUserGroups.AtsAdmin});
    }
}

