/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.console;

import java.util.HashSet;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.db.internal.callable.PurgeAttributesDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.console.AbstractDatastoreConsoleCommand;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class PurgeAttributeCommand
extends AbstractDatastoreConsoleCommand {
    private SqlJoinFactory joinFactory;

    public void setSqlJoinFactory(SqlJoinFactory joinFactory) {
        this.joinFactory = joinFactory;
    }

    public String getName() {
        return "purge_attribute";
    }

    public String getDescription() {
        return "Purges attribute instances from datastore";
    }

    public String getUsage() {
        return "[force=<TRUE|FALSE>] attr_id=<ATTRIBUTE_ID,...>";
    }

    public Callable<Void> createCallable(final Console console, ConsoleParameters params) {
        String[] attrIds = params.getArray("attr_id");
        final HashSet<AttributeId> longIds = new HashSet<AttributeId>();
        String[] stringArray = attrIds;
        int n = attrIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            longIds.add(AttributeId.valueOf((String)id));
            ++n2;
        }
        boolean force = params.getBoolean("force");
        JdbcClient jdbcClient = this.getJdbcClient();
        if (force) {
            return new PurgeAttributesDatabaseTxCallable(this.getLogger(), this.getSession(), jdbcClient, this.joinFactory, longIds, console);
        }
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                console.writeln((Object)"Attribute IDs: ");
                console.writeln((Object)Collections.toString((String)", ", (Iterable)longIds));
                console.writeln((Object)"Re-run with the force option to execute the command");
                return null;
            }
        };
    }
}

