/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentFolderNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceFolderNode;

public class TmfProjectNode
extends TmfProjectTreeNode {
    public static final String TRACE_FOLDER_NAME = "Traces";
    public static final String EXPER_FOLDER_NAME = "Experiments";
    private final IProject fProject;
    private boolean fIsTmfProject;
    private boolean fIsOpen;
    private TmfTraceFolderNode fTracesFolder;
    private TmfExperimentFolderNode fExperimentsFolder;

    public TmfProjectNode(IProject project) {
        this(null, project);
    }

    public TmfProjectNode(ITmfProjectTreeNode parent, IProject project) {
        super(parent);
        this.fProject = project;
        this.updateState();
    }

    @Override
    public String getName() {
        return this.fProject.getName();
    }

    @Override
    public void refreshChildren() {
        if (!this.fIsOpen || !this.fIsTmfProject) {
            return;
        }
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.fProject.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 2) {
                    String name = resource.getName();
                    if (name.equals(TRACE_FOLDER_NAME) && !this.isIncluded(true, name, this.fChildren)) {
                        this.fTracesFolder = new TmfTraceFolderNode(this, (IFolder)resource);
                        this.fChildren.add(this.fTracesFolder);
                    } else if (name.equals(EXPER_FOLDER_NAME) && !this.isIncluded(false, name, this.fChildren)) {
                        this.fExperimentsFolder = new TmfExperimentFolderNode(this, (IFolder)resource);
                        this.fChildren.add(this.fExperimentsFolder);
                    }
                }
                ++n2;
            }
            ArrayList<ITmfProjectTreeNode> toRemove = new ArrayList<ITmfProjectTreeNode>();
            for (ITmfProjectTreeNode node : this.fChildren) {
                if (this.exists(node.getName(), resources)) {
                    node.refreshChildren();
                    continue;
                }
                toRemove.add(node);
            }
            for (ITmfProjectTreeNode node : toRemove) {
                this.fChildren.remove(node);
            }
        }
        catch (CoreException coreException) {}
    }

    private boolean isIncluded(boolean isTraces, String name, List<ITmfProjectTreeNode> list) {
        boolean found = false;
        for (ITmfProjectTreeNode node : list) {
            if (node instanceof TmfTraceFolderNode && isTraces) {
                found |= node.getName().equals(name);
                continue;
            }
            if (!(node instanceof TmfExperimentFolderNode) || isTraces) continue;
            found |= node.getName().equals(name);
        }
        return found;
    }

    private boolean exists(String name, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void openProject() {
        try {
            this.fProject.open(null);
            this.updateState();
            this.refreshChildren();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void closeProject() {
        try {
            this.fProject.close(null);
            this.updateState();
            this.removeChildren();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean isTmfProject(IProject project) {
        boolean result = false;
        if (project != null && project.isAccessible()) {
            try {
                result = project.hasNature("org.eclipse.linuxtools.tmf.project.nature");
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public void updateState() {
        boolean bl = this.fIsOpen = this.fProject != null ? this.fProject.isAccessible() : false;
        if (!this.fIsOpen) {
            this.removeChildren();
        }
        this.fIsTmfProject = this.isTmfProject(this.fProject);
    }

    public boolean isTmfProject() {
        return this.fIsTmfProject;
    }

    public boolean isOpen() {
        return this.fIsOpen;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public TmfTraceFolderNode getTracesFolder() {
        return this.fTracesFolder;
    }

    public TmfExperimentFolderNode getExperimentsFolder() {
        return this.fExperimentsFolder;
    }
}

