/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.handlers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.parsers.ParserProviderManager;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class SelectParserContributionItem
extends CompoundContributionItem {
    private static final ImageDescriptor SELECTED_ICON = ImageDescriptor.createFromImage((Image)TmfUiPlugin.getDefault().getImageFromPath("icons/elcl16/bullet.gif"));

    protected IContributionItem[] getContributionItems() {
        LinkedList<MenuManager> list = new LinkedList<MenuManager>();
        ParserProviderManager.getParserMap();
        String parser = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ISelection selection = page.getSelection("org.eclipse.linuxtools.tmf.ui.views.project");
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            if (!(element instanceof TmfTraceNode)) {
                return new IContributionItem[0];
            }
            TmfTraceNode trace = (TmfTraceNode)element;
            IResource resource = trace.getResource();
            if (trace.getParent() instanceof TmfExperimentNode) {
                resource = trace.getProject().getTracesFolder().getTraceForLocation(resource.getLocation()).getResource();
            }
            try {
                parser = resource.getPersistentProperty(ParserProviderManager.PARSER_PROPERTY);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry<String, Map<String, String>> providerEntry : ParserProviderManager.getParserMap().entrySet()) {
            MenuManager subMenu = new MenuManager(providerEntry.getKey());
            for (Map.Entry<String, String> entry : providerEntry.getValue().entrySet()) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("org.eclipse.linuxtools.tmf.ui.commandparameter.project.trace.selectparser.parser", entry.getValue());
                ImageDescriptor icon = null;
                if (entry.getValue().equals(parser)) {
                    icon = SELECTED_ICON;
                }
                CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "my.parameterid", "org.eclipse.linuxtools.tmf.ui.command.project.trace.selectparser", params, icon, null, null, entry.getKey().replaceAll("&", "&&"), null, null, 8, null, true);
                subMenu.add((IContributionItem)new CommandContributionItem(param));
            }
            list.add(subMenu);
        }
        return list.toArray(new IContributionItem[list.size()]);
    }
}

