/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util.visitor;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.visitor.IDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.ITreeTraversal;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public class DepthFirstTraversal<T>
implements ITreeTraversal<T> {
    private final IDepthFirstVisitor<T> m_visitor;
    private final Function<T, Stream<? extends T>> m_childrenSupplier;

    protected DepthFirstTraversal(IDepthFirstVisitor<T> visitor, Function<T, Stream<? extends T>> childrenSupplier) {
        this.m_visitor = visitor;
        this.m_childrenSupplier = childrenSupplier;
    }

    @Override
    public TreeVisitResult traverse(T root) {
        return this.doVisitInternal(Ensure.notNull(root), 0, 0);
    }

    protected TreeVisitResult doVisitInternal(T toVisit, int level, int index) {
        TreeVisitResult childResult;
        TreeVisitResult nextAction = this.m_visitor.preVisit(toVisit, level, index);
        if (nextAction == TreeVisitResult.TERMINATE) {
            return TreeVisitResult.TERMINATE;
        }
        if (nextAction != TreeVisitResult.SKIP_SUBTREE && (childResult = this.visitChildren(toVisit, level + 1)) == TreeVisitResult.TERMINATE) {
            return TreeVisitResult.TERMINATE;
        }
        boolean continueVisit = this.m_visitor.postVisit(toVisit, level, index);
        if (!continueVisit) {
            return TreeVisitResult.TERMINATE;
        }
        return nextAction;
    }

    protected TreeVisitResult visitChildren(T parent, int level) {
        Stream<Object> children = this.m_childrenSupplier.apply(parent);
        if (children == null) {
            return TreeVisitResult.CONTINUE;
        }
        AtomicInteger index = new AtomicInteger();
        return children.map(child -> this.visitChild(child, level, index.getAndIncrement())).filter(DepthFirstTraversal::isAbortResult).map(DepthFirstTraversal::mapNextActionForParent).findAny().orElse(TreeVisitResult.CONTINUE);
    }

    protected static TreeVisitResult mapNextActionForParent(TreeVisitResult nextAction) {
        if (nextAction == TreeVisitResult.SKIP_SIBLINGS) {
            return TreeVisitResult.CONTINUE;
        }
        return nextAction;
    }

    protected static boolean isAbortResult(TreeVisitResult nextAction) {
        return nextAction == TreeVisitResult.TERMINATE || nextAction == TreeVisitResult.SKIP_SIBLINGS;
    }

    protected TreeVisitResult visitChild(T child, int level, int index) {
        if (child == null) {
            return TreeVisitResult.CONTINUE;
        }
        return this.doVisitInternal(child, level, index);
    }
}

