/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public final class CompositeObject
implements Comparable<CompositeObject> {
    private final Object[] m_value;
    private Integer m_hash;

    public CompositeObject(Object ... a) {
        this.m_value = a;
        this.m_hash = null;
    }

    public static CompositeObject concat(CompositeObject ... objects) {
        if (objects == null || objects.length < 1) {
            return new CompositeObject(new Object[0]);
        }
        Object[] a = new Object[CompositeObject.getCombinedSize(objects)];
        int pos = 0;
        for (CompositeObject o : objects) {
            int num;
            if (o == null || o.m_value == null || (num = o.m_value.length) <= 0) continue;
            System.arraycopy(o.m_value, 0, a, pos, num);
            pos += num;
        }
        return new CompositeObject(a);
    }

    private static int getCombinedSize(CompositeObject ... objects) {
        return Arrays.stream(objects).filter(Objects::nonNull).map(o -> o.m_value).filter(Objects::nonNull).mapToInt(o -> ((Object[])o).length).sum();
    }

    private static int compareImpl(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        return a.toString().compareTo(b.toString());
    }

    public Object[] array() {
        return Arrays.copyOf(this.m_value, this.m_value.length);
    }

    public int hashCode() {
        if (this.m_hash == null) {
            this.m_hash = Arrays.hashCode(this.m_value);
        }
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeObject other = (CompositeObject)obj;
        return Arrays.equals(this.m_value, other.m_value);
    }

    @Override
    public int compareTo(CompositeObject o) {
        Object[] me = this.m_value;
        Object[] other = o.m_value;
        if (me == other) {
            return 0;
        }
        if (me == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        int minSize = Math.min(me.length, other.length);
        for (int i = 0; i < minSize; ++i) {
            int c = CompositeObject.compareImpl(me[i], other[i]);
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(me.length, other.length);
    }

    public String toString(CharSequence delimiter) {
        if (this.m_value == null || this.m_value.length < 1) {
            return "";
        }
        return Arrays.stream(this.m_value).map(String::valueOf).collect(Collectors.joining(delimiter));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.toString(", "));
        sb.append(']');
        return sb.toString();
    }
}

