/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.commonmark.internal.Bracket;
import org.commonmark.internal.Delimiter;
import org.commonmark.internal.StaggeredDelimiterProcessor;
import org.commonmark.internal.inline.AsteriskDelimiterProcessor;
import org.commonmark.internal.inline.AutolinkInlineParser;
import org.commonmark.internal.inline.BackslashInlineParser;
import org.commonmark.internal.inline.BackticksInlineParser;
import org.commonmark.internal.inline.CoreLinkProcessor;
import org.commonmark.internal.inline.EntityInlineParser;
import org.commonmark.internal.inline.HtmlInlineParser;
import org.commonmark.internal.inline.LinkResultImpl;
import org.commonmark.internal.inline.ParsedInlineImpl;
import org.commonmark.internal.inline.UnderscoreDelimiterProcessor;
import org.commonmark.internal.util.Escaping;
import org.commonmark.internal.util.LinkScanner;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.SourceSpans;
import org.commonmark.node.Text;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.InlineParserContext;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.beta.InlineContentParser;
import org.commonmark.parser.beta.InlineContentParserFactory;
import org.commonmark.parser.beta.InlineParserState;
import org.commonmark.parser.beta.LinkInfo;
import org.commonmark.parser.beta.LinkProcessor;
import org.commonmark.parser.beta.LinkResult;
import org.commonmark.parser.beta.ParsedInline;
import org.commonmark.parser.beta.Position;
import org.commonmark.parser.beta.Scanner;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.text.Characters;

public class InlineParserImpl
implements InlineParser,
InlineParserState {
    private final InlineParserContext context;
    private final List<InlineContentParserFactory> inlineContentParserFactories;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private final List<LinkProcessor> linkProcessors;
    private final BitSet specialCharacters;
    private final BitSet linkMarkers;
    private Map<Character, List<InlineContentParser>> inlineParsers;
    private Scanner scanner;
    private boolean includeSourceSpans;
    private int trailingSpaces;
    private Delimiter lastDelimiter;
    private Bracket lastBracket;

    public InlineParserImpl(InlineParserContext context) {
        this.context = context;
        this.inlineContentParserFactories = this.calculateInlineContentParserFactories(context.getCustomInlineContentParserFactories());
        this.delimiterProcessors = InlineParserImpl.calculateDelimiterProcessors(context.getCustomDelimiterProcessors());
        this.linkProcessors = this.calculateLinkProcessors(context.getCustomLinkProcessors());
        this.linkMarkers = InlineParserImpl.calculateLinkMarkers(context.getCustomLinkMarkers());
        this.specialCharacters = InlineParserImpl.calculateSpecialCharacters(this.linkMarkers, this.delimiterProcessors.keySet(), this.inlineContentParserFactories);
    }

    private List<InlineContentParserFactory> calculateInlineContentParserFactories(List<InlineContentParserFactory> customFactories) {
        ArrayList<InlineContentParserFactory> list = new ArrayList<InlineContentParserFactory>(customFactories);
        list.add(new BackslashInlineParser.Factory());
        list.add(new BackticksInlineParser.Factory());
        list.add(new EntityInlineParser.Factory());
        list.add(new AutolinkInlineParser.Factory());
        list.add(new HtmlInlineParser.Factory());
        return list;
    }

    private List<LinkProcessor> calculateLinkProcessors(List<LinkProcessor> linkProcessors) {
        ArrayList<LinkProcessor> list = new ArrayList<LinkProcessor>(linkProcessors);
        list.add(new CoreLinkProcessor());
        return list;
    }

    private static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(List<DelimiterProcessor> delimiterProcessors) {
        HashMap<Character, DelimiterProcessor> map = new HashMap<Character, DelimiterProcessor>();
        InlineParserImpl.addDelimiterProcessors(List.of(new AsteriskDelimiterProcessor(), new UnderscoreDelimiterProcessor()), map);
        InlineParserImpl.addDelimiterProcessors(delimiterProcessors, map);
        return map;
    }

    private static void addDelimiterProcessors(Iterable<DelimiterProcessor> delimiterProcessors, Map<Character, DelimiterProcessor> map) {
        for (DelimiterProcessor delimiterProcessor : delimiterProcessors) {
            char closing;
            char opening = delimiterProcessor.getOpeningCharacter();
            if (opening == (closing = delimiterProcessor.getClosingCharacter())) {
                DelimiterProcessor old = map.get(Character.valueOf(opening));
                if (old != null && old.getOpeningCharacter() == old.getClosingCharacter()) {
                    StaggeredDelimiterProcessor s;
                    if (old instanceof StaggeredDelimiterProcessor) {
                        s = (StaggeredDelimiterProcessor)old;
                    } else {
                        s = new StaggeredDelimiterProcessor(opening);
                        s.add(old);
                    }
                    s.add(delimiterProcessor);
                    map.put(Character.valueOf(opening), s);
                    continue;
                }
                InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
                continue;
            }
            InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
            InlineParserImpl.addDelimiterProcessorForChar(closing, delimiterProcessor, map);
        }
    }

    private static void addDelimiterProcessorForChar(char delimiterChar, DelimiterProcessor toAdd, Map<Character, DelimiterProcessor> delimiterProcessors) {
        DelimiterProcessor existing = delimiterProcessors.put(Character.valueOf(delimiterChar), toAdd);
        if (existing != null) {
            throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + delimiterChar + "'");
        }
    }

    private static BitSet calculateLinkMarkers(Set<Character> linkMarkers) {
        BitSet bitSet = new BitSet();
        for (Character c : linkMarkers) {
            bitSet.set(c.charValue());
        }
        bitSet.set(33);
        return bitSet;
    }

    private static BitSet calculateSpecialCharacters(BitSet linkMarkers, Set<Character> delimiterCharacters, List<InlineContentParserFactory> inlineContentParserFactories) {
        BitSet bitSet = (BitSet)linkMarkers.clone();
        for (Character c : delimiterCharacters) {
            bitSet.set(c.charValue());
        }
        for (InlineContentParserFactory factory : inlineContentParserFactories) {
            for (Character c : factory.getTriggerCharacters()) {
                bitSet.set(c.charValue());
            }
        }
        bitSet.set(91);
        bitSet.set(93);
        bitSet.set(33);
        bitSet.set(10);
        return bitSet;
    }

    private Map<Character, List<InlineContentParser>> createInlineContentParsers() {
        HashMap<Character, List<InlineContentParser>> map = new HashMap<Character, List<InlineContentParser>>();
        for (InlineContentParserFactory factory : this.inlineContentParserFactories) {
            InlineContentParser parser = factory.create();
            for (Character c : factory.getTriggerCharacters()) {
                map.computeIfAbsent(c, k -> new ArrayList()).add(parser);
            }
        }
        return map;
    }

    @Override
    public Scanner scanner() {
        return this.scanner;
    }

    @Override
    public void parse(SourceLines lines, Node block) {
        List<? extends Node> nodes;
        this.reset(lines);
        while ((nodes = this.parseInline()) != null) {
            for (Node node : nodes) {
                block.appendChild(node);
            }
        }
        this.processDelimiters(null);
        this.mergeChildTextNodes(block);
    }

    void reset(SourceLines lines) {
        this.scanner = Scanner.of(lines);
        this.includeSourceSpans = !lines.getSourceSpans().isEmpty();
        this.trailingSpaces = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
        this.inlineParsers = this.createInlineContentParsers();
    }

    private Text text(SourceLines sourceLines) {
        Text text = new Text(sourceLines.getContent());
        text.setSourceSpans(sourceLines.getSourceSpans());
        return text;
    }

    private List<? extends Node> parseInline() {
        List<? extends Node> nodes;
        DelimiterProcessor delimiterProcessor;
        char c = this.scanner.peek();
        switch (c) {
            case '[': {
                return List.of(this.parseOpenBracket());
            }
            case ']': {
                return List.of(this.parseCloseBracket());
            }
            case '\n': {
                return List.of(this.parseLineBreak());
            }
            case '\u0000': {
                return null;
            }
        }
        if (this.linkMarkers.get(c)) {
            Position markerPosition = this.scanner.position();
            List<? extends Node> nodes2 = this.parseLinkMarker();
            if (nodes2 != null) {
                return nodes2;
            }
            this.scanner.setPosition(markerPosition);
        }
        if (!this.specialCharacters.get(c)) {
            return List.of(this.parseText());
        }
        List<InlineContentParser> inlineParsers = this.inlineParsers.get(Character.valueOf(c));
        if (inlineParsers != null) {
            Position position = this.scanner.position();
            for (InlineContentParser inlineParser : inlineParsers) {
                ParsedInline parsedInline = inlineParser.tryParse(this);
                if (parsedInline instanceof ParsedInlineImpl) {
                    ParsedInlineImpl parsedInlineImpl = (ParsedInlineImpl)parsedInline;
                    Node node = parsedInlineImpl.getNode();
                    this.scanner.setPosition(parsedInlineImpl.getPosition());
                    if (this.includeSourceSpans && node.getSourceSpans().isEmpty()) {
                        node.setSourceSpans(this.scanner.getSource(position, this.scanner.position()).getSourceSpans());
                    }
                    return List.of(node);
                }
                this.scanner.setPosition(position);
            }
        }
        if ((delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c))) != null && (nodes = this.parseDelimiters(delimiterProcessor, c)) != null) {
            return nodes;
        }
        return List.of(this.parseText());
    }

    private List<? extends Node> parseDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        DelimiterData res = this.scanDelimiters(delimiterProcessor, delimiterChar);
        if (res == null) {
            return null;
        }
        List<Text> characters = res.characters;
        this.lastDelimiter = new Delimiter(characters, delimiterChar, res.canOpen, res.canClose, this.lastDelimiter);
        if (this.lastDelimiter.previous != null) {
            this.lastDelimiter.previous.next = this.lastDelimiter;
        }
        return characters;
    }

    private Node parseOpenBracket() {
        Position start = this.scanner.position();
        this.scanner.next();
        Position contentPosition = this.scanner.position();
        Text node = this.text(this.scanner.getSource(start, contentPosition));
        this.addBracket(Bracket.link(node, start, contentPosition, this.lastBracket, this.lastDelimiter));
        return node;
    }

    private List<? extends Node> parseLinkMarker() {
        Position markerPosition = this.scanner.position();
        this.scanner.next();
        Position bracketPosition = this.scanner.position();
        if (this.scanner.next('[')) {
            Position contentPosition = this.scanner.position();
            Text bangNode = this.text(this.scanner.getSource(markerPosition, bracketPosition));
            Text bracketNode = this.text(this.scanner.getSource(bracketPosition, contentPosition));
            this.addBracket(Bracket.withMarker(bangNode, markerPosition, bracketNode, bracketPosition, contentPosition, this.lastBracket, this.lastDelimiter));
            return List.of(bangNode, bracketNode);
        }
        return null;
    }

    private Node parseCloseBracket() {
        Position beforeClose = this.scanner.position();
        this.scanner.next();
        Position afterClose = this.scanner.position();
        Bracket opener = this.lastBracket;
        if (opener == null) {
            return this.text(this.scanner.getSource(beforeClose, afterClose));
        }
        if (!opener.allowed) {
            this.removeLastBracket();
            return this.text(this.scanner.getSource(beforeClose, afterClose));
        }
        Node linkOrImage = this.parseLinkOrImage(opener, beforeClose);
        if (linkOrImage != null) {
            return linkOrImage;
        }
        this.scanner.setPosition(afterClose);
        this.removeLastBracket();
        return this.text(this.scanner.getSource(beforeClose, afterClose));
    }

    private Node parseLinkOrImage(Bracket opener, Position beforeClose) {
        LinkInfo linkInfo = this.parseLinkInfo(opener, beforeClose);
        if (linkInfo == null) {
            return null;
        }
        Position processorStartPosition = this.scanner.position();
        for (LinkProcessor linkProcessor : this.linkProcessors) {
            LinkResult linkResult = linkProcessor.process(linkInfo, this.scanner, this.context);
            if (!(linkResult instanceof LinkResultImpl)) {
                this.scanner.setPosition(processorStartPosition);
                continue;
            }
            LinkResultImpl result = (LinkResultImpl)linkResult;
            Node node = result.getNode();
            Position position = result.getPosition();
            boolean includeMarker = result.isIncludeMarker();
            switch (result.getType()) {
                case WRAP: {
                    this.scanner.setPosition(position);
                    return this.wrapBracket(opener, node, includeMarker);
                }
                case REPLACE: {
                    this.scanner.setPosition(position);
                    return this.replaceBracket(opener, node, includeMarker);
                }
            }
        }
        return null;
    }

    private LinkInfo parseLinkInfo(Bracket opener, Position beforeClose) {
        boolean textIsReference;
        Position afterClose = this.scanner.position();
        DestinationTitle destinationTitle = InlineParserImpl.parseInlineDestinationTitle(this.scanner);
        if (destinationTitle != null) {
            String text = this.scanner.getSource(opener.contentPosition, beforeClose).getContent();
            return new LinkInfoImpl(opener.markerNode, opener.bracketNode, text, null, destinationTitle.destination, destinationTitle.title, afterClose);
        }
        this.scanner.setPosition(afterClose);
        String label = InlineParserImpl.parseLinkLabel(this.scanner);
        if (label == null) {
            this.scanner.setPosition(afterClose);
        }
        boolean bl = textIsReference = label == null || label.isEmpty();
        if (opener.bracketAfter && textIsReference && opener.markerNode == null) {
            return null;
        }
        String text = this.scanner.getSource(opener.contentPosition, beforeClose).getContent();
        return new LinkInfoImpl(opener.markerNode, opener.bracketNode, text, label, null, null, afterClose);
    }

    private Node wrapBracket(Bracket opener, Node wrapperNode, boolean includeMarker) {
        Node n = opener.bracketNode.getNext();
        while (n != null) {
            Node next = n.getNext();
            wrapperNode.appendChild(n);
            n = next;
        }
        if (this.includeSourceSpans) {
            Position startPosition = includeMarker && opener.markerPosition != null ? opener.markerPosition : opener.bracketPosition;
            wrapperNode.setSourceSpans(this.scanner.getSource(startPosition, this.scanner.position()).getSourceSpans());
        }
        this.processDelimiters(opener.previousDelimiter);
        this.mergeChildTextNodes(wrapperNode);
        if (includeMarker && opener.markerNode != null) {
            opener.markerNode.unlink();
        }
        opener.bracketNode.unlink();
        this.removeLastBracket();
        if (opener.markerNode == null) {
            this.disallowPreviousLinks();
        }
        return wrapperNode;
    }

    private Node replaceBracket(Bracket opener, Node node, boolean includeMarker) {
        Node n;
        while (this.lastDelimiter != null && this.lastDelimiter != opener.previousDelimiter) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
        if (this.includeSourceSpans) {
            Position startPosition = includeMarker && opener.markerPosition != null ? opener.markerPosition : opener.bracketPosition;
            node.setSourceSpans(this.scanner.getSource(startPosition, this.scanner.position()).getSourceSpans());
        }
        this.removeLastBracket();
        Text text = n = includeMarker && opener.markerNode != null ? opener.markerNode : opener.bracketNode;
        while (n != null) {
            Node next = n.getNext();
            n.unlink();
            n = next;
        }
        if (opener.markerNode == null || !includeMarker) {
            this.disallowPreviousLinks();
        }
        return node;
    }

    private void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.bracketAfter = true;
        }
        this.lastBracket = bracket;
    }

    private void removeLastBracket() {
        this.lastBracket = this.lastBracket.previous;
    }

    private void disallowPreviousLinks() {
        Bracket bracket = this.lastBracket;
        while (bracket != null) {
            if (bracket.markerNode == null) {
                bracket.allowed = false;
            }
            bracket = bracket.previous;
        }
    }

    private static DestinationTitle parseInlineDestinationTitle(Scanner scanner) {
        if (!scanner.next('(')) {
            return null;
        }
        scanner.whitespace();
        String dest = InlineParserImpl.parseLinkDestination(scanner);
        if (dest == null) {
            return null;
        }
        String title = null;
        int whitespace = scanner.whitespace();
        if (whitespace >= 1) {
            title = InlineParserImpl.parseLinkTitle(scanner);
            scanner.whitespace();
        }
        if (!scanner.next(')')) {
            return null;
        }
        return new DestinationTitle(dest, title);
    }

    private static String parseLinkDestination(Scanner scanner) {
        String dest;
        char delimiter = scanner.peek();
        Position start = scanner.position();
        if (!LinkScanner.scanLinkDestination(scanner)) {
            return null;
        }
        if (delimiter == '<') {
            String rawDestination = scanner.getSource(start, scanner.position()).getContent();
            dest = rawDestination.substring(1, rawDestination.length() - 1);
        } else {
            dest = scanner.getSource(start, scanner.position()).getContent();
        }
        return Escaping.unescapeString(dest);
    }

    private static String parseLinkTitle(Scanner scanner) {
        Position start = scanner.position();
        if (!LinkScanner.scanLinkTitle(scanner)) {
            return null;
        }
        String rawTitle = scanner.getSource(start, scanner.position()).getContent();
        String title = rawTitle.substring(1, rawTitle.length() - 1);
        return Escaping.unescapeString(title);
    }

    static String parseLinkLabel(Scanner scanner) {
        if (!scanner.next('[')) {
            return null;
        }
        Position start = scanner.position();
        if (!LinkScanner.scanLinkLabelContent(scanner)) {
            return null;
        }
        Position end = scanner.position();
        if (!scanner.next(']')) {
            return null;
        }
        String content = scanner.getSource(start, end).getContent();
        if (content.length() > 999) {
            return null;
        }
        return content;
    }

    private Node parseLineBreak() {
        this.scanner.next();
        boolean hard = this.trailingSpaces >= 2;
        this.trailingSpaces = 0;
        if (hard) {
            return new HardLineBreak();
        }
        return new SoftLineBreak();
    }

    private Node parseText() {
        int end;
        char c;
        Position start = this.scanner.position();
        this.scanner.next();
        while ((c = this.scanner.peek()) != '\u0000' && !this.specialCharacters.get(c)) {
            this.scanner.next();
        }
        SourceLines source = this.scanner.getSource(start, this.scanner.position());
        String content = source.getContent();
        if (c == '\n') {
            end = Characters.skipBackwards(' ', content, content.length() - 1, 0) + 1;
            this.trailingSpaces = content.length() - end;
            content = content.substring(0, end);
        } else if (c == '\u0000') {
            end = Characters.skipSpaceTabBackwards(content, content.length() - 1, 0) + 1;
            content = content.substring(0, end);
        }
        Text text = new Text(content);
        text.setSourceSpans(source.getSourceSpans());
        return text;
    }

    private DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        boolean canClose;
        boolean canOpen;
        boolean rightFlanking;
        int before = this.scanner.peekPreviousCodePoint();
        Position start = this.scanner.position();
        int delimiterCount = this.scanner.matchMultiple(delimiterChar);
        if (delimiterCount < delimiterProcessor.getMinLength()) {
            this.scanner.setPosition(start);
            return null;
        }
        ArrayList<Text> delimiters = new ArrayList<Text>();
        this.scanner.setPosition(start);
        Position positionBefore = start;
        while (this.scanner.next(delimiterChar)) {
            delimiters.add(this.text(this.scanner.getSource(positionBefore, this.scanner.position())));
            positionBefore = this.scanner.position();
        }
        int after = this.scanner.peekCodePoint();
        boolean beforeIsPunctuation = before == 0 || Characters.isPunctuationCodePoint(before);
        boolean beforeIsWhitespace = before == 0 || Characters.isWhitespaceCodePoint(before);
        boolean afterIsPunctuation = after == 0 || Characters.isPunctuationCodePoint(after);
        boolean afterIsWhitespace = after == 0 || Characters.isWhitespaceCodePoint(after);
        boolean leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
        boolean bl = rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        if (delimiterChar == '_') {
            canOpen = leftFlanking && (!rightFlanking || beforeIsPunctuation);
            canClose = rightFlanking && (!leftFlanking || afterIsPunctuation);
        } else {
            canOpen = leftFlanking && delimiterChar == delimiterProcessor.getOpeningCharacter();
            canClose = rightFlanking && delimiterChar == delimiterProcessor.getClosingCharacter();
        }
        return new DelimiterData(delimiters, canOpen, canClose);
    }

    private void processDelimiters(Delimiter stackBottom) {
        HashMap<Character, Delimiter> openersBottom = new HashMap<Character, Delimiter>();
        Delimiter closer = this.lastDelimiter;
        while (closer != null && closer.previous != stackBottom) {
            closer = closer.previous;
        }
        while (closer != null) {
            Text delimiter;
            int i;
            char delimiterChar = closer.delimiterChar;
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delimiterChar));
            if (!closer.canClose() || delimiterProcessor == null) {
                closer = closer.next;
                continue;
            }
            char openingDelimiterChar = delimiterProcessor.getOpeningCharacter();
            int usedDelims = 0;
            boolean openerFound = false;
            boolean potentialOpenerFound = false;
            Delimiter opener = closer.previous;
            while (opener != null && opener != stackBottom && opener != openersBottom.get(Character.valueOf(delimiterChar))) {
                if (opener.canOpen() && opener.delimiterChar == openingDelimiterChar) {
                    potentialOpenerFound = true;
                    usedDelims = delimiterProcessor.process(opener, closer);
                    if (usedDelims > 0) {
                        openerFound = true;
                        break;
                    }
                }
                opener = opener.previous;
            }
            if (!openerFound) {
                if (!potentialOpenerFound) {
                    openersBottom.put(Character.valueOf(delimiterChar), closer.previous);
                    if (!closer.canOpen()) {
                        this.removeDelimiterKeepNode(closer);
                    }
                }
                closer = closer.next;
                continue;
            }
            for (i = 0; i < usedDelims; ++i) {
                delimiter = opener.characters.remove(opener.characters.size() - 1);
                delimiter.unlink();
            }
            for (i = 0; i < usedDelims; ++i) {
                delimiter = closer.characters.remove(0);
                delimiter.unlink();
            }
            this.removeDelimitersBetween(opener, closer);
            if (opener.length() == 0) {
                this.removeDelimiterAndNodes(opener);
            }
            if (closer.length() != 0) continue;
            Delimiter next = closer.next;
            this.removeDelimiterAndNodes(closer);
            closer = next;
        }
        while (this.lastDelimiter != null && this.lastDelimiter != stackBottom) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    private void removeDelimitersBetween(Delimiter opener, Delimiter closer) {
        Delimiter delimiter = closer.previous;
        while (delimiter != null && delimiter != opener) {
            Delimiter previousDelimiter = delimiter.previous;
            this.removeDelimiterKeepNode(delimiter);
            delimiter = previousDelimiter;
        }
    }

    private void removeDelimiterAndNodes(Delimiter delim) {
        this.removeDelimiter(delim);
    }

    private void removeDelimiterKeepNode(Delimiter delim) {
        this.removeDelimiter(delim);
    }

    private void removeDelimiter(Delimiter delim) {
        if (delim.previous != null) {
            delim.previous.next = delim.next;
        }
        if (delim.next == null) {
            this.lastDelimiter = delim.previous;
        } else {
            delim.next.previous = delim.previous;
        }
    }

    private void mergeChildTextNodes(Node node) {
        if (node.getFirstChild() == null) {
            return;
        }
        this.mergeTextNodesInclusive(node.getFirstChild(), node.getLastChild());
    }

    private void mergeTextNodesInclusive(Node fromNode, Node toNode) {
        Text first = null;
        Text last = null;
        int length = 0;
        for (Node node = fromNode; node != null; node = node.getNext()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                if (first == null) {
                    first = text;
                }
                length += text.getLiteral().length();
                last = text;
            } else {
                this.mergeIfNeeded(first, last, length);
                first = null;
                last = null;
                length = 0;
                this.mergeChildTextNodes(node);
            }
            if (node == toNode) break;
        }
        this.mergeIfNeeded(first, last, length);
    }

    private void mergeIfNeeded(Text first, Text last, int textLength) {
        if (first != null && last != null && first != last) {
            StringBuilder sb = new StringBuilder(textLength);
            sb.append(first.getLiteral());
            SourceSpans sourceSpans = null;
            if (this.includeSourceSpans) {
                sourceSpans = new SourceSpans();
                sourceSpans.addAll(first.getSourceSpans());
            }
            Node stop = last.getNext();
            for (Node node = first.getNext(); node != stop; node = node.getNext()) {
                sb.append(((Text)node).getLiteral());
                if (sourceSpans != null) {
                    sourceSpans.addAll(node.getSourceSpans());
                }
                Node unlink = node;
                unlink.unlink();
            }
            String literal = sb.toString();
            first.setLiteral(literal);
            if (sourceSpans != null) {
                first.setSourceSpans(sourceSpans.getSourceSpans());
            }
        }
    }

    private static class DelimiterData {
        final List<Text> characters;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(List<Text> characters, boolean canOpen, boolean canClose) {
            this.characters = characters;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }
    }

    private static class DestinationTitle {
        final String destination;
        final String title;

        public DestinationTitle(String destination, String title) {
            this.destination = destination;
            this.title = title;
        }
    }

    private static class LinkInfoImpl
    implements LinkInfo {
        private final Text marker;
        private final Text openingBracket;
        private final String text;
        private final String label;
        private final String destination;
        private final String title;
        private final Position afterTextBracket;

        private LinkInfoImpl(Text marker, Text openingBracket, String text, String label, String destination, String title, Position afterTextBracket) {
            this.marker = marker;
            this.openingBracket = openingBracket;
            this.text = text;
            this.label = label;
            this.destination = destination;
            this.title = title;
            this.afterTextBracket = afterTextBracket;
        }

        @Override
        public Text marker() {
            return this.marker;
        }

        @Override
        public Text openingBracket() {
            return this.openingBracket;
        }

        @Override
        public String text() {
            return this.text;
        }

        @Override
        public String label() {
            return this.label;
        }

        @Override
        public String destination() {
            return this.destination;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public Position afterTextBracket() {
            return this.afterTextBracket;
        }
    }
}

