/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeFulfillsEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;

public class DataTypeAssignableEvaluator
implements Predicate<IDataType> {
    private final IDataType m_childType;
    private final Function<IDataType, Stream<IDataType>> m_childrenSupplier;
    private final boolean m_childIsArray;
    private final boolean m_requiresInstanceOfCheck;

    public DataTypeAssignableEvaluator(IDataType child) {
        this(child, IDataType::childTypes);
    }

    public DataTypeAssignableEvaluator(IDataType child, Function<IDataType, Stream<IDataType>> childrenSupplier) {
        this.m_childType = child;
        this.m_childIsArray = child.flavor() == IDataType.DataTypeFlavor.Array;
        this.m_childrenSupplier = childrenSupplier;
        this.m_requiresInstanceOfCheck = DataTypeAssignableEvaluator.isInstanceOfCheckRequired(child);
    }

    private static boolean isInstanceOfCheckRequired(IDataType child) {
        if (!(child instanceof IES6Class)) {
            return false;
        }
        IES6Class clazz = (IES6Class)child;
        return !clazz.isEnum() && !clazz.isTypeAlias();
    }

    public boolean fulfills(IDataType base) {
        if (base == null) {
            return false;
        }
        return new DataTypeFulfillsEvaluator(this, this.m_childrenSupplier).fulfills(base);
    }

    @Override
    public boolean test(IDataType dataType) {
        if (this.m_childType == dataType) {
            return true;
        }
        if (this.m_childIsArray) {
            if (dataType.flavor() == IDataType.DataTypeFlavor.Array) {
                if (this.m_childType.arrayDimension() != dataType.arrayDimension()) {
                    return false;
                }
                IDataType childArrComponentType = this.m_childrenSupplier.apply(this.m_childType).findAny().orElse(null);
                IDataType baseArrComponentType = this.m_childrenSupplier.apply(dataType).findAny().orElse(null);
                if (childArrComponentType == null || baseArrComponentType == null) {
                    return false;
                }
                return new DataTypeAssignableEvaluator(childArrComponentType, this.m_childrenSupplier).fulfills(baseArrComponentType);
            }
            return false;
        }
        if (this.m_requiresInstanceOfCheck && DataTypeAssignableEvaluator.isInstanceOfCheckRequired(dataType)) {
            return ((IES6Class)this.m_childType).isInstanceOf((IES6Class)dataType);
        }
        return false;
    }
}

