/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.execute;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionServicesRegistry;
import org.eclipse.passage.lic.api.conditions.mining.MinedConditionsRegistry;
import org.eclipse.passage.lic.api.io.HashesRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.Service;
import org.eclipse.passage.lic.api.registry.ServiceId;
import org.eclipse.passage.lic.base.registry.JointRegistry;
import org.eclipse.passage.lic.base.registry.ReadOnlyRegistry;

public interface LicensingDirection {
    public MinedConditionsRegistry conditionMiners();

    public LicenseAcquisitionServicesRegistry acquirers();

    public HashesRegistry hashes();

    public static final class Joint
    implements LicensingDirection {
        private final List<LicensingDirection> delegates;

        public Joint(LicensingDirection ... delegates) {
            this.delegates = Arrays.asList(delegates);
        }

        private <I extends ServiceId, S extends Service<I>> Registry<I, S> registries(Function<LicensingDirection, Supplier<Registry<I, S>>> retrieve) {
            return new ReadOnlyRegistry((Registry)new JointRegistry(this.delegates.stream().map(delegate -> (Registry)((Supplier)retrieve.apply((LicensingDirection)delegate)).get()).collect(Collectors.toList())));
        }

        @Override
        public MinedConditionsRegistry conditionMiners() {
            return () -> this.registries(LicensingDirection::conditionMiners);
        }

        @Override
        public LicenseAcquisitionServicesRegistry acquirers() {
            return () -> this.registries(LicensingDirection::acquirers);
        }

        @Override
        public HashesRegistry hashes() {
            return () -> this.registries(LicensingDirection::hashes);
        }
    }
}

