/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.forms.finder.widgets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.swt.finder.ReferenceBy;
import org.eclipse.swtbot.swt.finder.SWTBotWidget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.hamcrest.SelfDescribing;

@SWTBotWidget(clasz=Hyperlink.class, preferredName="hyperlink", referenceBy={ReferenceBy.MNEMONIC})
public class SWTBotHyperlink
extends AbstractSWTBotControl<Hyperlink> {
    public SWTBotHyperlink(Hyperlink w) throws WidgetNotFoundException {
        super((Control)w);
    }

    public SWTBotHyperlink(Hyperlink w, SelfDescribing description) throws WidgetNotFoundException {
        super((Control)w, description);
    }

    public AbstractSWTBot<Hyperlink> click() {
        return this.click(true);
    }

    public AbstractSWTBot<Hyperlink> click(String hyperlinkText) {
        this.log.debug("Clicking on {}", (Object)SWTUtils.getText((Object)this.widget));
        String text = this.getText();
        boolean isText = text.contains(">" + hyperlinkText + "<");
        Assert.isLegal((boolean)isText, (Object)("Link does not contain text (" + hyperlinkText + "). It contains (" + text + ")"));
        hyperlinkText = this.extractHyperlinkTextOrHREF(hyperlinkText, text);
        this.notify(13, this.createHyperlinkEvent(hyperlinkText));
        this.log.debug("Clicked on {}", (Object)SWTUtils.getText((Object)this.widget));
        return this.click(true);
    }

    private String extractHyperlinkTextOrHREF(String hyperlinkText, String text) {
        Pattern pattern = Pattern.compile(".*<[aA] [hH][rR][eE][fF]\\s*=\\s*['\"](.*)['\"]>" + hyperlinkText + "</[aA]>.*");
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : hyperlinkText;
    }

    private Event createHyperlinkEvent(String hyperlinkText) {
        Event e = this.createEvent();
        e.text = hyperlinkText;
        return e;
    }
}

