/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.ImageTooltip;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.MenuIconDialogEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.MUiFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MenuEditor
extends AbstractComponentEditor<MMenu> {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    private final List<Action> actions = new ArrayList<Action>();
    @Inject
    @Optional
    private IProject project;
    @Inject
    IEclipseContext eclipseContext;
    private Action addExpression;

    @Inject
    public MenuEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.MenuEditor_AddHandledMenuItem, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.HandledMenuItem")){

            public void run() {
                MenuEditor.this.handleAdd(MenuPackageImpl.Literals.HANDLED_MENU_ITEM, false);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_AddMenu, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu")){

            public void run() {
                MenuEditor.this.handleAdd(MenuPackageImpl.Literals.MENU, false);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_AddDirectMenuItem, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.DirectMenuItem")){

            public void run() {
                MenuEditor.this.handleAdd(MenuPackageImpl.Literals.DIRECT_MENU_ITEM, false);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_AddSeparator, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.MenuSeparator")){

            public void run() {
                MenuEditor.this.handleAdd(MenuPackageImpl.Literals.MENU_SEPARATOR, true);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_AddDynamicMenuContribution, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.DynamicMenuContribution")){

            public void run() {
                MenuEditor.this.handleAdd(MenuPackageImpl.Literals.DYNAMIC_MENU_CONTRIBUTION, false);
            }
        });
        this.addExpression = new Action(this.Messages.MenuEditor_AddCoreExpression, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.CoreExpression")){

            public void run() {
                MUIElement e = (MUIElement)MenuEditor.this.getMaster().getValue();
                Command cmd = SetCommand.create((EditingDomain)MenuEditor.this.getEditingDomain(), (Object)e, (Object)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE_WHEN, (Object)MUiFactory.INSTANCE.createCoreExpression());
                if (cmd.canExecute()) {
                    MenuEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        };
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu");
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.MenuEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        EObject o;
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = new Composite(parent, 0);
            this.stackLayout = new StackLayout();
            this.composite.setLayout((Layout)this.stackLayout);
            this.createForm(this.composite, this.context, this.getMaster(), false, false);
            this.createForm(this.composite, this.context, this.getMaster(), true, false);
            if (this.getEditor().isModelFragment()) {
                this.createForm(this.composite, this.context, this.getMaster(), false, true);
            }
        }
        if (this.stackLayout.topControl != (topControl = Util.isImport(o = (EObject)object) && this.getEditor().isModelFragment() ? this.composite.getChildren()[2] : (o.eContainer() instanceof MWindow || o.eContainer() == null ? this.composite.getChildren()[1] : this.composite.getChildren()[0]))) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        this.getMaster().setValue((Object)((MMenu)object));
        this.enableIdGenerator(UiPackageImpl.Literals.UI_LABEL__LABEL, ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID, null);
        return this.composite;
    }

    protected Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<MMenu> master, boolean rootMenu, boolean isImport) {
        Label l;
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        if (!rootMenu) {
            ControlFactory.createTranslatedTextField(parent, this.Messages.MenuEditor_LabelLabel, master, context, (IWidgetValueProperty<? super Text, String>)textProp, E4Properties.label(this.getEditingDomain()), this.resourcePool, this.project);
        }
        ControlFactory.createTextField(parent, this.Messages.MenuEditor_Mnemonics, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.mnemonics(this.getEditingDomain()));
        E4PickList pickList = new E4PickList(parent, 0, null, this, (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
        pickList.setText(this.Messages.MenuEditor_Children);
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        E4PickList.Struct defaultStruct = new E4PickList.Struct(this.Messages.MenuEditor_HandledMenuItem, MenuPackageImpl.Literals.HANDLED_MENU_ITEM, false);
        pickList.setInput(new E4PickList.Struct[]{new E4PickList.Struct(this.Messages.MenuEditor_Separator, MenuPackageImpl.Literals.MENU_SEPARATOR, true), new E4PickList.Struct(this.Messages.MenuEditor_Menu, MenuPackageImpl.Literals.MENU, false), defaultStruct, new E4PickList.Struct(this.Messages.MenuEditor_DirectMenuItem, MenuPackageImpl.Literals.DIRECT_MENU_ITEM, false), new E4PickList.Struct(this.Messages.MenuEditor_DynamicMenuContribution, MenuPackageImpl.Literals.DYNAMIC_MENU_CONTRIBUTION, false)});
        pickList.setSelection((ISelection)new StructuredSelection((Object)defaultStruct));
        pickList.getList().setInput((Object)E4Properties.children(this.getEditingDomain()).observeDetail(master));
        if (!rootMenu) {
            ControlFactory.createTranslatedTextField(parent, this.Messages.MenuEditor_Tooltip, master, context, (IWidgetValueProperty<? super Text, String>)textProp, E4Properties.tooltip(this.getEditingDomain()), this.resourcePool, this.project);
        }
        if (!rootMenu) {
            l = new Label(parent, 0);
            l.setText(this.Messages.MenuEditor_IconURI);
            l.setLayoutData((Object)new GridData());
            Text t = new Text(parent, 2048);
            ControlFactory.TextPasteHandler.createFor(t);
            t.setLayoutData((Object)new GridData(768));
            context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.iconUri(this.getEditingDomain()).observeDetail(master));
            new ImageTooltip((Control)t, this.Messages, this);
            final Button b = ControlFactory.createFindButton(parent, this.resourcePool);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuIconDialogEditor dialog = new MenuIconDialogEditor(b.getShell(), MenuEditor.this.eclipseContext, MenuEditor.this.project, MenuEditor.this.getEditingDomain(), (MMenu)MenuEditor.this.getMaster().getValue(), MenuEditor.this.Messages);
                    dialog.open();
                }
            });
        }
        l = new Label(parent, 0);
        l.setText(this.Messages.ModelTooling_UIElement_VisibleWhen);
        l.setLayoutData((Object)new GridData());
        ComboViewer combo = new ComboViewer(parent);
        combo.getControl().setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EClass) {
                    EClass eClass = (EClass)element;
                    return eClass.getName();
                }
                return super.getText(element);
            }
        });
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.Messages.MenuItemEditor_NoExpression);
        list.add(UiPackageImpl.Literals.CORE_EXPRESSION);
        list.add(UiPackageImpl.Literals.IMPERATIVE_EXPRESSION);
        list.addAll(this.getEditor().getFeatureClasses(UiPackageImpl.Literals.EXPRESSION, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE_WHEN));
        combo.setInput(list);
        context.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)combo), E4Properties.visibleWhen(this.getEditingDomain()).observeDetail(this.getMaster()), UpdateValueStrategy.create(new MenuItemEditor.EClass2EObject(this.Messages)), UpdateValueStrategy.create(new MenuItemEditor.EObject2EClass(this.Messages)));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.toBeRendered(this.getEditingDomain()));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_Visible, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.visible(this.getEditingDomain()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.accessibilityPhrase(this.getEditingDomain()));
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        if (this.project == null) {
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MMenu.class);
        folder.setSelection(0);
        return folder;
    }

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue<?>)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        final WritableList list = new WritableList();
        MMenu menu = (MMenu)element;
        if (menu.getVisibleWhen() != null) {
            list.add(0, (Object)menu.getVisibleWhen());
        }
        E4Properties.visibleWhen().observe((Object)menu).addValueChangeListener(event -> {
            if (event.diff.getOldValue() != null) {
                list.remove(event.diff.getOldValue());
            }
            if (event.diff.getNewValue() != null) {
                list.add(0, (Object)((MApplicationElement)event.diff.getNewValue()));
            }
        });
        IObservableList l = E4Properties.children().observe((Object)menu);
        l.addListChangeListener(event -> event.diff.accept((ListDiffVisitor)new ListDiffVisitor<MMenuElement>(){

            public void handleRemove(int index, MMenuElement element) {
                list.remove((Object)element);
            }

            public void handleMove(int oldIndex, int newIndex, MMenuElement element) {
                if (list.get(0) instanceof MExpression) {
                    ++oldIndex;
                    ++newIndex;
                }
                list.move(oldIndex, newIndex);
            }

            public void handleAdd(int index, MMenuElement element) {
                list.add((Object)element);
            }
        }));
        list.addAll((Collection)l);
        return list;
    }

    @Override
    public String getLabel(Object element) {
        MMenu menu = (MMenu)element;
        if (menu.getParent() == null) {
            EObject o = (EObject)element;
            if (o.eContainer() instanceof MWindow) {
                return this.Messages.MenuEditor_MainMenu;
            }
            if (menu.getTags().contains("ViewMenu")) {
                return this.Messages.MenuEditor_Label_ViewMenu;
            }
        } else if (menu.getTags().contains("ViewMenu")) {
            return this.Messages.MenuEditor_Label_ViewMenu;
        }
        return this.Messages.MenuEditor_Label;
    }

    @Override
    public String getDetailLabel(Object element) {
        return this.getLocalizedLabel((MUILabel)element);
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__LABEL}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__ICON_URI}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    protected void handleAdd(EClass eClass, boolean separator) {
        MMenuElement eObject = (MMenuElement)EcoreUtil.create((EClass)eClass);
        this.setElementId(eObject);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN, (Object)eObject);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            if (!separator) {
                this.getEditor().setSelection(eObject);
            }
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        if (((MMenu)this.getMaster().getValue()).getVisibleWhen() == null) {
            l.add(this.addExpression);
        }
        return l;
    }
}

