/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SyncStatus implements Enumerator
{
    DIRTY(0, "dirty", "dirty"),
    SYNC(1, "sync", "sync");

    public static final int DIRTY_VALUE = 0;
    public static final int SYNC_VALUE = 1;
    private static final SyncStatus[] VALUES_ARRAY;
    public static final List<SyncStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SyncStatus[]{DIRTY, SYNC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SyncStatus get(String literal) {
        SyncStatus[] syncStatusArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            SyncStatus result = syncStatusArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static SyncStatus getByName(String name) {
        SyncStatus[] syncStatusArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            SyncStatus result = syncStatusArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static SyncStatus get(int value) {
        switch (value) {
            case 0: {
                return DIRTY;
            }
            case 1: {
                return SYNC;
            }
        }
        return null;
    }

    private SyncStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

