/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.net4j.util.om.monitor.AbstractMonitor;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class NestedMonitor
extends AbstractMonitor {
    private AbstractMonitor parent;
    private double parentWork;
    private double sentToParent;
    private double scale;
    private boolean usedUp;

    public NestedMonitor(AbstractMonitor parent, double parentWork) {
        this.parent = parent;
        this.parentWork = parentWork > 0.0 ? parentWork : 0.0;
    }

    public AbstractMonitor getParent() {
        return this.parent;
    }

    public double getParentWork() {
        return this.parentWork;
    }

    @Override
    public boolean isCanceled() {
        return this.parent.isCanceled();
    }

    @Override
    public void checkCanceled() throws MonitorCanceledException {
        this.parent.checkCanceled();
    }

    @Override
    public OMMonitor begin(double totalWork) throws MonitorCanceledException {
        super.begin(totalWork);
        this.scale = totalWork > 0.0 ? this.parentWork / totalWork : 0.0;
        return this;
    }

    @Override
    public void worked(double work) throws MonitorCanceledException {
        if (!this.usedUp) {
            super.worked(work);
            double realWork = work > 0.0 ? this.scale * work : 0.0;
            this.parent.worked(realWork);
            this.sentToParent += realWork;
            if (this.sentToParent >= this.parentWork) {
                this.usedUp = true;
            }
        }
    }

    @Override
    public void done() {
        super.done();
        this.sentToParent = 0.0;
        this.usedUp = true;
    }

    @Override
    protected long getAsyncSchedulePeriod() {
        return this.parent.getAsyncSchedulePeriod();
    }

    @Override
    protected void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        this.parent.scheduleAtFixedRate(task, delay, period);
    }

    @Override
    protected Timer getTimer() {
        return this.parent.getTimer();
    }
}

