/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceNodeQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.ParentOperandFinder;
import org.eclipse.sirius.diagram.sequence.business.internal.util.RangeSetter;
import org.eclipse.sirius.diagram.sequence.business.internal.util.SubEventsHelper;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class Lifeline
extends AbstractSequenceNode
implements ISequenceEvent {
    public static final int VISUAL_ID = 3001;

    Lifeline(Node node) {
        super(node);
        Preconditions.checkArgument((boolean)Lifeline.notationPredicate().apply((Object)node), (Object)Messages.Lifeline_nonLifelineNode);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 3001, Lifeline.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    public InstanceRole getInstanceRole() {
        return (InstanceRole)ISequenceElementAccessor.getInstanceRole((View)this.getNotationNode().eContainer()).get();
    }

    @Override
    public Range getVerticalRange() {
        return new SequenceNodeQuery(this.getNotationNode()).getVerticalRange();
    }

    @Override
    public boolean isLogicallyInstantaneous() {
        return false;
    }

    @Override
    public void setVerticalRange(Range range) throws IllegalStateException {
        RangeSetter.setVerticalRange(this, range);
    }

    public Option<EndOfLife> getEndOfLife() {
        for (View child : Iterables.filter((Iterable)this.getNotationView().getChildren(), View.class)) {
            if (!EndOfLife.notationPredicate().apply((Object)child)) continue;
            return ISequenceElementAccessor.getEndOfLife(child);
        }
        return Options.newNone();
    }

    @Override
    public Option<Lifeline> getLifeline() {
        return Options.newSome((Object)this);
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        if (this.getNotationNode().getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)this.getNotationNode().getLayoutConstraint();
            Rectangle irBounds = this.getInstanceRole().getProperLogicalBounds();
            Point bottom = irBounds.getBottom();
            int width = bounds.getWidth();
            return new Rectangle(bottom.x - width / 2, bottom.y, bounds.getWidth(), bounds.getHeight());
        }
        throw new RuntimeException();
    }

    @Override
    public ISequenceEvent getParentEvent() {
        return null;
    }

    @Override
    public List<ISequenceEvent> getSubEvents() {
        return new SubEventsHelper(this).getSubEvents();
    }

    @Override
    public Collection<ISequenceEvent> getEventsToMoveWith() {
        return this.getSubEvents();
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range) {
        return new SubEventsHelper(this).canChildOccupy(child, range);
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range, List<ISequenceEvent> eventsToIgnore, Collection<Lifeline> lifelines) {
        return new SubEventsHelper(this).canChildOccupy(child, range, eventsToIgnore, lifelines);
    }

    @Override
    public Range getOccupiedRange() {
        return new ISequenceEventQuery(this).getOccupiedRange();
    }

    @Override
    public Range getValidSubEventsRange() {
        Range result = this.getVerticalRange();
        if (result.width() > 10) {
            result = result.shrinked(5);
        }
        return result;
    }

    public Option<Message> getDestructionMessage() {
        Option<EndOfLife> optEOL = this.getEndOfLife();
        if (optEOL.some()) {
            return ((EndOfLife)optEOL.get()).getDestructionMessage();
        }
        return Options.newNone();
    }

    public boolean isExplicitlyDestroyed() {
        Option<EndOfLife> optEOL = this.getEndOfLife();
        if (optEOL.some()) {
            return ((EndOfLife)optEOL.get()).isExplicitelyDestroyed();
        }
        return false;
    }

    public boolean isExplicitlyCreated() {
        InstanceRole opt = this.getInstanceRole();
        if (opt != null) {
            return opt.isExplicitlyCreated();
        }
        return false;
    }

    public Option<Message> getCreationMessage() {
        InstanceRole opt = this.getInstanceRole();
        if (opt != null) {
            return opt.getCreationMessage();
        }
        return Options.newNone();
    }

    @Override
    public Option<Operand> getParentOperand() {
        return this.getParentOperand(this.getVerticalRange());
    }

    public Option<Operand> getParentOperand(int verticalPosition) {
        return new ParentOperandFinder(this).getParentOperand(new Range(verticalPosition, verticalPosition));
    }

    public Option<Operand> getParentOperand(Range range) {
        return new ParentOperandFinder(this).getParentOperand(range);
    }

    @Override
    public ISequenceEvent getHierarchicalParentEvent() {
        return null;
    }

    public Collection<InteractionUse> getAllCoveringInteractionUses() {
        Predicate<InteractionUse> interactionUseCoveringLifeline = new Predicate<InteractionUse>(){

            public boolean apply(InteractionUse input) {
                return input.computeCoveredLifelines().contains(Lifeline.this);
            }
        };
        return Lists.newArrayList((Iterable)Iterables.filter(this.getDiagram().getAllInteractionUses(), (Predicate)interactionUseCoveringLifeline));
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getExecutionMapping()) && InstanceRole.viewpointElementPredicate().apply((Object)((DDiagramElement)input.eContainer()));
        }
    }
}

