/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.util.Arrays;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.pde.api.tools.annotations.NoReference;

public final class PrecisionPointList
extends PointList {
    private static final PrecisionPoint PRIVATE_POINT = new PrecisionPoint();
    private double[] decimalFractions = new double[0];

    public PrecisionPointList() {
    }

    public PrecisionPointList(int size) {
        super(size);
        this.decimalFractions = new double[size * 2];
    }

    public PrecisionPointList(int[] points) {
        super(points);
        this.decimalFractions = new double[points.length];
    }

    public PrecisionPointList(PointList points) {
        this(Arrays.copyOf(points.toIntArray(), points.arraySize()));
        if (points instanceof PrecisionPointList) {
            PrecisionPointList other = (PrecisionPointList)points;
            System.arraycopy(other.decimalFractions, 0, this.decimalFractions, 0, this.arraySize());
        }
    }

    @Override
    public void addAll(PointList points) {
        this.ensureCapacity(this.size() + points.size());
        if (points instanceof PrecisionPointList) {
            PrecisionPointList other = (PrecisionPointList)points;
            System.arraycopy(other.decimalFractions, 0, this.decimalFractions, this.arraySize(), other.arraySize());
        }
        super.addAll(points);
    }

    @Override
    public void addPoint(Point point) {
        this.ensureCapacity(this.size() + 1);
        if (point instanceof PrecisionPoint) {
            int index = this.arraySize();
            this.decimalFractions[index] = point.preciseX() - (double)point.x;
            this.decimalFractions[index + 1] = point.preciseY() - (double)point.y;
        }
        super.addPoint(point);
    }

    @Override
    Rectangle createBounds() {
        return new PrecisionRectangle();
    }

    private void ensureCapacity(int newSize) {
        int arraySize = newSize * 2;
        if (this.decimalFractions.length < arraySize) {
            this.decimalFractions = Arrays.copyOf(this.decimalFractions, Math.max(arraySize, this.size() * 4));
        }
    }

    @Override
    public PointList getCopy() {
        return new PrecisionPointList(this);
    }

    @Override
    public Point getPoint(int index) {
        return this.getPoint(new PrecisionPoint(), index);
    }

    @Override
    public Point getPoint(Point point, int index) {
        super.getPoint(point, index);
        int arrayIndex = index * 2;
        if (point instanceof PrecisionPoint) {
            PrecisionPoint precisePoint = (PrecisionPoint)point;
            precisePoint.translate(this.decimalFractions[arrayIndex], this.decimalFractions[arrayIndex + 1]);
        }
        return point;
    }

    @Override
    public void insertPoint(Point p, int index) {
        super.insertPoint(p, index);
        int length = this.decimalFractions.length;
        double[] old = this.decimalFractions;
        this.decimalFractions = new double[length + 2];
        int arrayIndex = index * 2;
        System.arraycopy(old, 0, this.decimalFractions, 0, arrayIndex);
        System.arraycopy(old, arrayIndex, this.decimalFractions, arrayIndex + 2, length - arrayIndex);
        this.decimalFractions[arrayIndex] = p.preciseX() - (double)p.x;
        this.decimalFractions[arrayIndex + 1] = p.preciseY() - (double)p.y;
    }

    @Override
    public void performScale(double factor) {
        int i = 0;
        while (i < this.size()) {
            this.getPoint(PRIVATE_POINT, i);
            PRIVATE_POINT.scale(factor);
            this.setPoint(PRIVATE_POINT, i);
            ++i;
        }
    }

    @Override
    public Point removePoint(int index) {
        int arraySize = this.arraySize();
        Point pt1 = super.removePoint(index);
        int arrayIndex = index * 2;
        PrecisionPoint pt2 = new PrecisionPoint(this.decimalFractions[arrayIndex], this.decimalFractions[arrayIndex + 1]);
        if (arrayIndex != arraySize - 2) {
            System.arraycopy(this.decimalFractions, arrayIndex + 2, this.decimalFractions, arrayIndex, arraySize - arrayIndex - 2);
        }
        ((Point)pt2).translate(pt1);
        return pt2;
    }

    @Override
    public void reverse() {
        super.reverse();
        int i = 0;
        int j = this.arraySize() - 2;
        while (i < this.size()) {
            double temp = this.decimalFractions[i];
            this.decimalFractions[i] = this.decimalFractions[j];
            this.decimalFractions[j] = temp;
            temp = this.decimalFractions[i + 1];
            this.decimalFractions[i + 1] = this.decimalFractions[j + 1];
            this.decimalFractions[j + 1] = temp;
            i += 2;
            j -= 2;
        }
    }

    @Override
    public void setPoint(Point point, int index) {
        super.setPoint(point, index);
        int arrayIndex = index * 2;
        this.decimalFractions[arrayIndex] = point.preciseX() - (double)point.x;
        this.decimalFractions[arrayIndex + 1] = point.preciseY() - (double)point.y;
    }

    @Override
    public void setSize(int newSize) {
        super.setSize(newSize);
        int arraySize = newSize * 2;
        if (this.decimalFractions.length > arraySize) {
            return;
        }
        this.decimalFractions = Arrays.copyOf(this.decimalFractions, arraySize);
    }

    @NoReference
    public double[] toDoubleArray() {
        int arraySize = this.arraySize();
        if (this.decimalFractions.length != arraySize) {
            this.decimalFractions = Arrays.copyOf(this.decimalFractions, arraySize);
        }
        return this.decimalFractions;
    }

    @Override
    public void transpose() {
        super.transpose();
        int i = 0;
        while (i < this.arraySize()) {
            double temp = this.decimalFractions[i];
            this.decimalFractions[i] = this.decimalFractions[i + 1];
            this.decimalFractions[i + 1] = temp;
            i += 2;
        }
    }
}

