/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.tools.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.tools.resolver.AbstractRangeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.resolver.CollectionDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Declaration;
import org.eclipse.persistence.jpa.jpql.tools.resolver.DerivedDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.resolver.EntityResolver;
import org.eclipse.persistence.jpa.jpql.tools.resolver.FromSubqueryResolver;
import org.eclipse.persistence.jpa.jpql.tools.resolver.IdentificationVariableResolver;
import org.eclipse.persistence.jpa.jpql.tools.resolver.NullResolver;
import org.eclipse.persistence.jpa.jpql.tools.resolver.RangeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Resolver;
import org.eclipse.persistence.jpa.jpql.tools.resolver.UnknownDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;

public class DeclarationResolver
extends Resolver {
    private List<Declaration> declarations;
    private DeclarationVisitor declarationVisitor;
    private QualifyRangeDeclarationVisitor qualifyRangeDeclarationVisitor;
    private JPQLQueryContext queryContext;
    private Map<String, Resolver> resolvers;
    private Map<IdentificationVariable, String> resultVariables;
    private RootObjectExpressionVisitor rootObjectExpressionVisitor;

    public DeclarationResolver(DeclarationResolver parent, JPQLQueryContext queryContext) {
        super(parent);
        this.initialize(queryContext);
    }

    protected final void addDeclaration(Declaration declaration) {
        this.declarations.add(declaration);
    }

    public void addRangeVariableDeclaration(String entityName, String variableName) {
        String internalVariableName = variableName.toUpperCase();
        if (!this.resolvers.containsKey(internalVariableName)) {
            Resolver resolver = new EntityResolver(this, entityName);
            resolver = new IdentificationVariableResolver(resolver, variableName);
            this.resolvers.put(internalVariableName, resolver);
            RangeDeclaration declaration = new RangeDeclaration();
            declaration.rootPath = entityName;
            declaration.identificationVariable = new IdentificationVariable(null, variableName);
            this.declarations.add(declaration);
        }
    }

    protected DeclarationVisitor buildDeclarationVisitor() {
        return new DeclarationVisitor();
    }

    protected RootObjectExpressionVisitor buildRootObjectExpressionVisitor() {
        return new RootObjectExpressionVisitor();
    }

    @Override
    protected IType buildType() {
        return this.getTypeHelper().unknownType();
    }

    @Override
    protected ITypeDeclaration buildTypeDeclaration() {
        return this.getTypeHelper().unknownTypeDeclaration();
    }

    @Override
    protected void checkParent(Resolver parent) {
    }

    public void convertUnqualifiedDeclaration(Declaration declaration, String outerVariableName) {
        QualifyRangeDeclarationVisitor visitor = this.qualifyRangeDeclarationVisitor();
        try {
            visitor.oldDeclaration = declaration;
            visitor.outerVariableName = outerVariableName;
            declaration.declarationExpression.accept(visitor);
        }
        finally {
            visitor.oldDeclaration = null;
            visitor.newDeclaration = null;
            visitor.outerVariableName = null;
        }
    }

    public void dispose() {
        this.resolvers.clear();
        this.declarations.clear();
        this.resultVariables.clear();
    }

    public Declaration getDeclaration(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.getVariableName().equalsIgnoreCase(variableName)) continue;
            return declaration;
        }
        return null;
    }

    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    protected DeclarationVisitor getDeclarationVisitor() {
        if (this.declarationVisitor == null) {
            this.declarationVisitor = this.buildDeclarationVisitor();
        }
        return this.declarationVisitor;
    }

    @Override
    public DeclarationResolver getParent() {
        return (DeclarationResolver)super.getParent();
    }

    @Override
    public IQuery getQuery() {
        return this.queryContext.getQuery();
    }

    protected JPQLQueryContext getQueryContext() {
        return this.queryContext;
    }

    public Resolver getResolver(String variableName) {
        Resolver resolver = this.getResolverImp(variableName = variableName.toUpperCase());
        if (resolver == null && this.getParent() != null) {
            resolver = this.getParent().getResolver(variableName);
        }
        if (resolver == null) {
            resolver = new NullResolver(this);
            this.resolvers.put(variableName, resolver);
        }
        return resolver;
    }

    protected Resolver getResolverImp(String variableName) {
        return this.resolvers.get(variableName);
    }

    public Set<String> getResultVariables() {
        return new HashSet<String>(this.resultVariables.values());
    }

    public Map<IdentificationVariable, String> getResultVariablesMap() {
        return this.resultVariables;
    }

    protected RootObjectExpressionVisitor getRootObjectExpressionVisitor() {
        if (this.rootObjectExpressionVisitor == null) {
            this.rootObjectExpressionVisitor = this.buildRootObjectExpressionVisitor();
        }
        return this.rootObjectExpressionVisitor;
    }

    public boolean hasJoins() {
        for (Declaration declaration : this.declarations) {
            if (!declaration.hasJoins()) continue;
            return true;
        }
        return false;
    }

    protected void initialize(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
        this.resolvers = new HashMap<String, Resolver>();
        this.declarations = new LinkedList<Declaration>();
        this.resultVariables = new HashMap<IdentificationVariable, String>();
    }

    public boolean isCollectionIdentificationVariable(String variableName) {
        boolean result = this.isCollectionIdentificationVariableImp(variableName);
        if (!result && this.getParent() != null) {
            result = this.getParent().isCollectionIdentificationVariableImp(variableName);
        }
        return result;
    }

    protected boolean isCollectionIdentificationVariableImp(String variableName) {
        block4: for (Declaration declaration : this.declarations) {
            switch (declaration.getType()) {
                case COLLECTION: {
                    return declaration.getVariableName().equalsIgnoreCase(variableName);
                }
                case DERIVED: 
                case RANGE: {
                    AbstractRangeDeclaration rangeDeclaration = (AbstractRangeDeclaration)declaration;
                    for (Join join : rangeDeclaration.getJoins()) {
                        IMapping mapping;
                        String joinVariableName = this.queryContext.literal(join.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                        if (!joinVariableName.equalsIgnoreCase(variableName)) continue;
                        Resolver resolver = this.getResolver(variableName);
                        IMapping iMapping = mapping = resolver != null ? resolver.getMapping() : null;
                        return mapping != null && mapping.isCollection();
                    }
                    continue block4;
                }
            }
        }
        return false;
    }

    public boolean isRangeIdentificationVariable(String variableName) {
        boolean result = this.isRangeIdentificationVariableImp(variableName);
        if (!result && this.getParent() != null) {
            result = this.getParent().isRangeIdentificationVariableImp(variableName);
        }
        return result;
    }

    protected boolean isRangeIdentificationVariableImp(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.getType().isRange() || !declaration.getVariableName().equalsIgnoreCase(variableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isResultVariable(String variable) {
        return this.resultVariables.containsValue(variable.toUpperCase());
    }

    public void populate(Expression expression) {
        DeclarationVisitor visitor = this.getDeclarationVisitor();
        try {
            expression.accept(visitor);
        }
        finally {
            visitor.currentDeclaration = null;
        }
    }

    protected QualifyRangeDeclarationVisitor qualifyRangeDeclarationVisitor() {
        if (this.qualifyRangeDeclarationVisitor == null) {
            this.qualifyRangeDeclarationVisitor = new QualifyRangeDeclarationVisitor();
        }
        return this.qualifyRangeDeclarationVisitor;
    }

    protected Resolver resolveRootObject(Expression expression) {
        RootObjectExpressionVisitor visitor = this.getRootObjectExpressionVisitor();
        try {
            expression.accept(visitor);
            Resolver resolver = visitor.resolver;
            return resolver;
        }
        finally {
            visitor.resolver = null;
        }
    }

    protected String visitDeclaration(Expression expression, Expression identificationVariable) {
        String variableName = this.queryContext.literal(identificationVariable, LiteralType.IDENTIFICATION_VARIABLE);
        if (variableName != "") {
            String internalVariableName = variableName.toUpperCase();
            if (!this.resolvers.containsKey(internalVariableName)) {
                Resolver resolver = this.resolveRootObject(expression);
                resolver = new IdentificationVariableResolver(resolver, variableName);
                this.resolvers.put(internalVariableName, resolver);
            }
            return variableName;
        }
        return "";
    }

    protected class DeclarationVisitor
    extends AbstractExpressionVisitor {
        protected boolean buildingDeclaration;
        protected boolean collectResultVariable;
        protected Declaration currentDeclaration;

        protected DeclarationVisitor() {
        }

        @Override
        public void visit(AbstractSchemaName expression) {
            this.currentDeclaration = new RangeDeclaration();
            this.currentDeclaration.rootPath = expression.getText();
            DeclarationResolver.this.declarations.add(this.currentDeclaration);
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visit(CollectionMemberDeclaration expression) {
            CollectionDeclaration declaration = new CollectionDeclaration();
            declaration.declarationExpression = expression;
            declaration.baseExpression = expression.getCollectionValuedPathExpression();
            declaration.rootPath = declaration.baseExpression.toActualText();
            DeclarationResolver.this.declarations.add(declaration);
            Expression identificationVariable = expression.getIdentificationVariable();
            String variableName = DeclarationResolver.this.visitDeclaration(expression, identificationVariable);
            if (variableName != "") {
                declaration.identificationVariable = (IdentificationVariable)identificationVariable;
            }
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            this.currentDeclaration = new DerivedDeclaration();
            this.currentDeclaration.rootPath = expression.toActualText();
            DeclarationResolver.this.declarations.add(this.currentDeclaration);
        }

        @Override
        public void visit(DeleteClause expression) {
            try {
                this.buildingDeclaration = true;
                expression.getRangeVariableDeclaration().accept(this);
                this.buildingDeclaration = false;
                this.currentDeclaration.declarationExpression = expression;
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        @Override
        public void visit(DeleteStatement expression) {
            expression.getDeleteClause().accept(this);
        }

        @Override
        public void visit(FromClause expression) {
            expression.getDeclaration().accept(this);
        }

        @Override
        public void visit(IdentificationVariable expression) {
            if (this.collectResultVariable) {
                DeclarationResolver.this.resultVariables.put(expression, expression.getText().toUpperCase());
            }
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            try {
                expression.getRangeVariableDeclaration().accept(this);
                expression.getJoins().accept(this);
                this.currentDeclaration.declarationExpression = expression;
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        @Override
        public void visit(Join expression) {
            AbstractRangeDeclaration rangeDeclaration = (AbstractRangeDeclaration)this.currentDeclaration;
            Expression identificationVariable = expression.getIdentificationVariable();
            DeclarationResolver.this.visitDeclaration(expression, identificationVariable);
            rangeDeclaration.addJoin(expression);
        }

        @Override
        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept(this);
        }

        @Override
        public void visit(NullExpression expression) {
            if (this.buildingDeclaration) {
                this.currentDeclaration = new UnknownDeclaration();
                this.currentDeclaration.baseExpression = expression;
                this.currentDeclaration.rootPath = "";
                DeclarationResolver.this.declarations.add(this.currentDeclaration);
            }
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            Expression rootObject = expression.getRootObject();
            this.buildingDeclaration = true;
            rootObject.accept(this);
            this.buildingDeclaration = false;
            this.currentDeclaration.baseExpression = expression;
            Expression identificationVariable = expression.getIdentificationVariable();
            String variableName = DeclarationResolver.this.visitDeclaration(rootObject, identificationVariable);
            if (variableName != "") {
                this.currentDeclaration.identificationVariable = (IdentificationVariable)identificationVariable;
            }
        }

        @Override
        public void visit(ResultVariable expression) {
            this.collectResultVariable = true;
            expression.getResultVariable().accept(this);
            this.collectResultVariable = false;
        }

        @Override
        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SelectStatement expression) {
            expression.getFromClause().accept(this);
            expression.getSelectClause().accept(this);
        }

        @Override
        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept(this);
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            expression.getFromClause().accept(this);
        }

        @Override
        public void visit(UpdateClause expression) {
            try {
                this.buildingDeclaration = true;
                expression.getRangeVariableDeclaration().accept(this);
                this.buildingDeclaration = false;
                this.currentDeclaration.declarationExpression = expression;
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        @Override
        public void visit(UpdateStatement expression) {
            expression.getUpdateClause().accept(this);
        }
    }

    protected static class QualifyRangeDeclarationVisitor
    extends AbstractExpressionVisitor {
        protected Declaration newDeclaration;
        protected Declaration oldDeclaration;
        protected String outerVariableName;

        protected QualifyRangeDeclarationVisitor() {
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            this.newDeclaration.rootPath = expression.toActualText();
            this.newDeclaration.baseExpression = expression;
        }

        @Override
        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept(this);
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            this.newDeclaration = new DerivedDeclaration();
            expression.setVirtualIdentificationVariable(this.outerVariableName, this.newDeclaration.rootPath);
            expression.getRootObject().accept(this);
        }
    }

    protected class RootObjectExpressionVisitor
    extends AnonymousExpressionVisitor {
        protected Resolver resolver;

        protected RootObjectExpressionVisitor() {
        }

        @Override
        protected void visit(Expression expression) {
            this.resolver = DeclarationResolver.this.queryContext.getResolver(expression);
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            this.resolver = new FromSubqueryResolver(DeclarationResolver.this, DeclarationResolver.this.queryContext, expression);
        }

        @Override
        public void visit(SubExpression expression) {
            expression.getExpression().accept(this);
        }
    }
}

