/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.taginfo;

import java.io.Reader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.ui.JSdocContentAccess;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.ui.internal.taginfo.HTMLPrinter;
import org.eclipse.wst.jsdt.web.ui.internal.taginfo.JsWordFinder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.taginfo.AbstractHoverProcessor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSDTHoverProcessor
extends AbstractHoverProcessor {
    private static final String[] PARTITION_TYPES = new String[]{"org.eclipse.wst.html.SCRIPT", "org.eclipse.wst.html.SCRIPT.EVENTHANDLER"};
    private final long LABEL_FLAGS = 283710660642007L;
    private final long LOCAL_VARIABLE_FLAGS = 283710660707543L;

    private String getHoverInfo(IJavaScriptElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList(buffer);
                IJavaScriptElement curr = result[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    HTMLPrinter.addBullet(buffer, this.getInfoText(curr));
                }
                HTMLPrinter.endBulletList(buffer);
                ++i;
            }
        } else {
            IJavaScriptElement curr = result[0];
            if (curr == null) {
                return null;
            }
            if (curr instanceof IMember) {
                Reader reader;
                IMember member = (IMember)curr;
                HTMLPrinter.addSmallHeader(buffer, this.getInfoText((IJavaScriptElement)member));
                try {
                    reader = JSdocContentAccess.getHTMLContentReader((IMember)member, (boolean)true, (boolean)true);
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return null;
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph(buffer, reader);
                }
            } else if (curr.getElementType() == 14) {
                HTMLPrinter.addSmallHeader(buffer, this.getInfoText(curr));
            }
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0);
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block11: {
            IDOMModel xmlModel = null;
            try {
                IDOMDocument xmlDoc;
                JsTranslationAdapter adapter;
                xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(textViewer.getDocument());
                if (xmlModel == null || (adapter = (JsTranslationAdapter)(xmlDoc = xmlModel.getDocument()).getAdapterFor(IJsTranslation.class)) == null) break block11;
                try {
                    boolean proceed = false;
                    ITypedRegion[] partitions = xmlDoc.getStructuredDocument().computePartitioning(hoverRegion.getOffset(), hoverRegion.getLength());
                    int i = 0;
                    while (i < partitions.length) {
                        int j = 0;
                        while (j < PARTITION_TYPES.length) {
                            if (PARTITION_TYPES[j].equals(partitions[i].getType())) {
                                proceed = true;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (proceed) {
                        IJsTranslation translation = adapter.getJsTranslation(true);
                        IJavaScriptElement[] result = translation.getElementsFromJsRange(translation.getJavaScriptOffset(hoverRegion.getOffset()), translation.getJavaScriptOffset(hoverRegion.getOffset() + hoverRegion.getLength()));
                        String string = translation.fixupMangledName(this.getHoverInfo(result));
                        return string;
                    }
                }
                catch (BadLocationException badLocationException) {
                }
            }
            finally {
                if (xmlModel != null) {
                    xmlModel.releaseFromRead();
                }
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JsWordFinder.findWord(textViewer.getDocument(), offset);
    }

    private String getInfoText(IJavaScriptElement member) {
        long flags = member.getElementType() == 14 ? 283710660707543L : 283710660642007L;
        String label = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)member, (long)flags);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }
}

