/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.constraints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.FolderNode;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.LeafNode;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.constraints.Messages;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditorModelListener;
import org.eclipse.emf.common.notify.Notification;

public class SQLConstraintsTreeViewerInput
implements ISchemaObjectEditorModelListener {
    public static final String CONSTRAINTS_NODE = Messages.SQLConstraintsTreeViewerInput_constraints;
    public static final String PRIMAEY_KEY_NODE = Messages.SQLConstraintsTreeViewerInput_pk;
    public static final String FOREIGN_KEY_NODE = Messages.SQLConstraintsTreeViewerInput_fk;
    public static final String UNIQUE_CONSTRAINT_NODE = Messages.SQLConstraintsTreeViewerInput_unique_constraint;
    public static final String CHECK_CONSTRAINT_NODE = Messages.SQLConstraintsTreeViewerInput_ck;
    public static final String COLUMN_CHECK_CONSTRAINT_NODE = Messages.SQLConstraintsTreeViewerInput_column_ck;
    private BaseTable _table;
    private FolderNode _constraintsFolderNode;
    private FolderNode _uniqueFolderNode;
    private FolderNode _pkFolderNode;
    private FolderNode _fkFolderNode;
    private FolderNode _ckFolderNode;
    private FolderNode _root;
    private boolean _isGenerated = false;
    private List _dirtyList;

    public SQLConstraintsTreeViewerInput(BaseTable table) {
        this._table = table;
        this.generateInput();
    }

    public void resetInput(BaseTable table) {
        this._table = table;
        this.generateInput();
    }

    private void generateInput() {
        this._dirtyList = new ArrayList();
        if (this._isGenerated) {
            this.addDirtyConstraint(this._pkFolderNode, this._dirtyList);
            this.addDirtyConstraint(this._uniqueFolderNode, this._dirtyList);
            this.addDirtyConstraint(this._fkFolderNode, this._dirtyList);
            this.addDirtyConstraint(this._ckFolderNode, this._dirtyList);
        }
        if (!this._isGenerated) {
            this._root = new FolderNode("root");
            this._constraintsFolderNode = new FolderNode(CONSTRAINTS_NODE);
            this._root.addChild(this._constraintsFolderNode);
            this._pkFolderNode = new FolderNode(PRIMAEY_KEY_NODE);
            this._constraintsFolderNode.addChild(this._pkFolderNode);
            this._uniqueFolderNode = new FolderNode(UNIQUE_CONSTRAINT_NODE);
            this._constraintsFolderNode.addChild(this._uniqueFolderNode);
            this._fkFolderNode = new FolderNode(FOREIGN_KEY_NODE);
            this._constraintsFolderNode.addChild(this._fkFolderNode);
            this._ckFolderNode = new FolderNode(Messages.SQLConstraintsTreeViewerInput_ck);
            this._constraintsFolderNode.addChild(this._ckFolderNode);
        }
        this._isGenerated = true;
        this.refresh();
    }

    public FolderNode getRoot() {
        return this._root;
    }

    public FolderNode getConstraintsNode() {
        return this._constraintsFolderNode;
    }

    public FolderNode getPKFolderNode() {
        return this._pkFolderNode;
    }

    public FolderNode getFKFolderNode() {
        return this._fkFolderNode;
    }

    public FolderNode getUniqueFolderNode() {
        return this._uniqueFolderNode;
    }

    public FolderNode getCKFolderNode() {
        return this._ckFolderNode;
    }

    public LeafNode getNode(Constraint constraint) {
        for (LeafNode leaf : this._pkFolderNode.getChildren()) {
            if (leaf.getData() != constraint) continue;
            return leaf;
        }
        for (LeafNode leaf : this._fkFolderNode.getChildren()) {
            if (leaf.getData() != constraint) continue;
            return leaf;
        }
        for (LeafNode leaf : this._uniqueFolderNode.getChildren()) {
            if (leaf.getData() != constraint) continue;
            return leaf;
        }
        for (LeafNode leaf : this._ckFolderNode.getChildren()) {
            if (leaf.getData() != constraint) continue;
            return leaf;
        }
        return null;
    }

    private void addDirtyConstraint(FolderNode folder, List dirtyList) {
        for (LeafNode node : folder.getChildren()) {
            if (!node.isDirty()) continue;
            dirtyList.add(node.getData());
        }
    }

    private void refresh() {
        LeafNode node;
        this._uniqueFolderNode.getChildren().clear();
        this._pkFolderNode.getChildren().clear();
        this._fkFolderNode.getChildren().clear();
        this._ckFolderNode.getChildren().clear();
        if (this._table.getPrimaryKey() != null) {
            this._pkFolderNode.addChild(new LeafNode(this._table.getPrimaryKey().getName(), this._table.getPrimaryKey()));
        }
        for (UniqueConstraint unique : this._table.getUniqueConstraints()) {
            if (unique instanceof PrimaryKey) continue;
            node = new LeafNode(unique.getName(), unique);
            if (this._dirtyList.contains(unique)) {
                node.markDirty(true);
            }
            this._uniqueFolderNode.addChild(node);
        }
        for (ForeignKey fk : this._table.getForeignKeys()) {
            node = new LeafNode(fk.getName(), fk);
            if (this._dirtyList.contains(fk)) {
                node.markDirty(true);
            }
            this._fkFolderNode.addChild(node);
        }
        ArrayList ckConstraints = new ArrayList();
        for (Object obj : this._table.getConstraints()) {
            if (!(obj instanceof CheckConstraint)) continue;
            ckConstraints.add(obj);
        }
        for (CheckConstraint ck : ckConstraints) {
            LeafNode node2 = new LeafNode(ck.getName(), ck);
            if (this._dirtyList.contains(ck)) {
                node2.markDirty(true);
            }
            this._ckFolderNode.addChild(node2);
        }
    }

    public void notifyChanged(Notification msg) {
        if (msg.getNotifier() instanceof BaseTable) {
            msg.getFeatureID(BaseTable.class);
        }
    }
}

