/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.widgets.Display;

public class PDFDocument
implements Drawable {
    Device device;
    long surface;
    long cairo;
    boolean isGCCreated = false;
    boolean disposed = false;
    double widthInPoints;
    double heightInPoints;

    public PDFDocument(String filename, double widthInPoints, double heightInPoints) {
        if (filename == null) {
            SWT.error(4);
        }
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        this.widthInPoints = widthInPoints;
        this.heightInPoints = heightInPoints;
        byte[] filenameBytes = Converter.wcsToMbcs(filename, true);
        this.surface = Cairo.cairo_pdf_surface_create(filenameBytes, widthInPoints, heightInPoints);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        this.cairo = Cairo.cairo_create(this.surface);
        if (this.cairo == 0L) {
            Cairo.cairo_surface_destroy(this.surface);
            this.surface = 0L;
            SWT.error(2);
        }
        try {
            this.device = Display.getDefault();
        }
        catch (Exception e) {
            this.device = null;
        }
    }

    public PDFDocument(Device device, String filename, double widthInPoints, double heightInPoints) {
        if (filename == null) {
            SWT.error(4);
        }
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        this.device = device;
        this.widthInPoints = widthInPoints;
        this.heightInPoints = heightInPoints;
        byte[] filenameBytes = Converter.wcsToMbcs(filename, true);
        this.surface = Cairo.cairo_pdf_surface_create(filenameBytes, widthInPoints, heightInPoints);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        this.cairo = Cairo.cairo_create(this.surface);
        if (this.cairo == 0L) {
            Cairo.cairo_surface_destroy(this.surface);
            this.surface = 0L;
            SWT.error(2);
        }
    }

    public void newPage() {
        if (this.disposed) {
            SWT.error(24);
        }
        Cairo.cairo_show_page(this.cairo);
    }

    public void newPage(double widthInPoints, double heightInPoints) {
        if (this.disposed) {
            SWT.error(24);
        }
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        Cairo.cairo_show_page(this.cairo);
        Cairo.cairo_pdf_surface_set_size(this.surface, widthInPoints, heightInPoints);
        this.widthInPoints = widthInPoints;
        this.heightInPoints = heightInPoints;
    }

    public double getWidth() {
        if (this.disposed) {
            SWT.error(24);
        }
        return this.widthInPoints;
    }

    public double getHeight() {
        if (this.disposed) {
            SWT.error(24);
        }
        return this.heightInPoints;
    }

    @Override
    public long internal_new_GC(GCData data) {
        if (this.disposed) {
            SWT.error(24);
        }
        if (this.isGCCreated) {
            SWT.error(5);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.cairo = this.cairo;
            data.width = (int)this.widthInPoints;
            data.height = (int)this.heightInPoints;
            if (this.device != null) {
                data.foregroundRGBA = this.device.getSystemColor((int)2).handle;
                data.backgroundRGBA = this.device.getSystemColor((int)1).handle;
                data.font = this.device.getSystemFont();
            } else {
                data.foregroundRGBA = new GdkRGBA();
                data.foregroundRGBA.red = 0.0;
                data.foregroundRGBA.green = 0.0;
                data.foregroundRGBA.blue = 0.0;
                data.foregroundRGBA.alpha = 1.0;
                data.backgroundRGBA = new GdkRGBA();
                data.backgroundRGBA.red = 1.0;
                data.backgroundRGBA.green = 1.0;
                data.backgroundRGBA.blue = 1.0;
                data.backgroundRGBA.alpha = 1.0;
            }
        }
        this.isGCCreated = true;
        return this.cairo;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    @Override
    public boolean isAutoScalable() {
        return false;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.cairo != 0L) {
            Cairo.cairo_destroy(this.cairo);
            this.cairo = 0L;
        }
        if (this.surface != 0L) {
            Cairo.cairo_surface_finish(this.surface);
            Cairo.cairo_surface_destroy(this.surface);
            this.surface = 0L;
        }
    }
}

