/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.dynamic;

import org.eclipse.help.internal.dynamic.FilterResolver;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class FilterResolverExtension
implements FilterResolver.Extension {
    private static final String NAME_ACTIVITY = "activity";
    private static final String NAME_CATEGORY = "category";

    public boolean isHandled(String name) {
        return name.equals(NAME_ACTIVITY) || name.equals(NAME_CATEGORY);
    }

    public boolean isFiltered(String name, String value) {
        if (name.equals(NAME_ACTIVITY)) {
            return FilterResolverExtension.filterByActivity(value);
        }
        if (name.equals(NAME_CATEGORY)) {
            return FilterResolverExtension.filterByCategory(value);
        }
        return false;
    }

    private static boolean filterByCategory(String categoryId) {
        try {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
            if (activityManager.getCategory(categoryId).isDefined()) {
                return !WorkbenchActivityHelper.isEnabled((IActivityManager)activityManager, (String)categoryId);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean filterByActivity(String activityId) {
        try {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
            if (activityManager.getActivity(activityId).isDefined()) {
                return !activityManager.getActivity(activityId).isEnabled();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

