/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.urlhandling;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;

public class MarketplaceUrlUtil {
    static final String MPC_STATE = "mpc_state";
    static final String MPC_INSTALL = "mpc_install";
    private static final String PARAM_SPLIT_REGEX = "&";
    private static final String EQUALS_REGEX = "=";

    public static Map<String, String> parseQuery(String url) {
        return MarketplaceUrlUtil.parseQuery(MarketplaceUrlUtil.parseUri(url));
    }

    public static Map<String, String> parseQuery(URI uri) {
        String[] params;
        String query;
        String string = query = uri == null ? null : uri.getQuery();
        if (query == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        String[] stringArray = params = query.split(PARAM_SPLIT_REGEX);
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] keyValue = param.split(EQUALS_REGEX);
            if (keyValue.length == 2) {
                String key = keyValue[0];
                String value = keyValue[1];
                values.put(key, value);
            }
            ++n2;
        }
        return values;
    }

    public static URI parseUri(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String getMpcState(Map<String, String> query) {
        return query.get(MPC_STATE);
    }

    public static String getInstallId(Map<String, String> query) {
        return query.get(MPC_INSTALL);
    }

    public static CatalogDescriptor findCatalogDescriptor(String url, boolean allowUnknown) {
        CatalogDescriptor descriptor = CatalogRegistry.getInstance().findCatalogDescriptor(url);
        if (descriptor == null && allowUnknown) {
            try {
                descriptor = new CatalogDescriptor(URLUtil.toURL((String)url), "org.eclipse.epp.mpc.descriptorHint");
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return descriptor;
    }
}

