/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.model;

import org.eclipse.terminal.internal.model.TerminalTextDataStore;
import org.eclipse.terminal.model.ITerminalTextData;
import org.eclipse.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.terminal.model.LineSegment;
import org.eclipse.terminal.model.TerminalStyle;

public class TerminalTextDataFastScroll
implements ITerminalTextData {
    final ITerminalTextData fData;
    private int fHeight;
    private int fMaxHeight;
    int fOffset;

    public TerminalTextDataFastScroll(ITerminalTextData data, int maxHeight) {
        this.fMaxHeight = maxHeight;
        this.fData = data;
        this.fData.setDimensions(maxHeight, this.fData.getWidth());
        if (maxHeight > 2) {
            this.moveOffset(-2);
        }
    }

    public TerminalTextDataFastScroll(int maxHeight) {
        this(new TerminalTextDataStore(), maxHeight);
    }

    public TerminalTextDataFastScroll() {
        this(new TerminalTextDataStore(), 1);
    }

    int getPositionOfLine(int line) {
        return (line + this.fOffset) % this.fMaxHeight;
    }

    void moveOffset(int delta) {
        if (Math.abs(delta) >= this.fMaxHeight) {
            throw new IllegalArgumentException("Parameter 'delta' absolute value (" + delta + ") must be less than maxHeight(" + this.fMaxHeight + ")");
        }
        this.fOffset = (this.fMaxHeight + this.fOffset + delta) % this.fMaxHeight;
    }

    @Override
    public void addLine() {
        if (this.getHeight() < this.fMaxHeight) {
            this.setDimensions(this.getHeight() + 1, this.getWidth());
        } else {
            this.scroll(0, this.getHeight(), -1);
        }
    }

    @Override
    public void cleanLine(int line) {
        this.fData.cleanLine(this.getPositionOfLine(line));
    }

    @Override
    public void copy(ITerminalTextData source) {
        int n = source.getHeight();
        this.setDimensions(source.getHeight(), source.getWidth());
        int i = 0;
        while (i < n) {
            this.fData.copyLine(source, i, this.getPositionOfLine(i));
            ++i;
        }
    }

    @Override
    public void copyLine(ITerminalTextData source, int sourceLine, int destLine) {
        this.fData.copyLine(source, sourceLine, this.getPositionOfLine(destLine));
    }

    @Override
    public void copyRange(ITerminalTextData source, int sourceStartLine, int destStartLine, int length) {
        if (destStartLine < 0 || destStartLine + length > this.fHeight) {
            throw new IllegalArgumentException("Value of 'destStartLine'+'length' parameters must be valid line (range [0-" + this.getHeight() + "). Parameter values: 'destStartLine'=" + destStartLine + ", 'size'=" + length);
        }
        int i = 0;
        while (i < length) {
            this.fData.copyLine(source, i + sourceStartLine, this.getPositionOfLine(i + destStartLine));
            ++i;
        }
    }

    @Override
    public char getChar(int line, int column) {
        this.validateLineParameter(line);
        return this.fData.getChar(this.getPositionOfLine(line), column);
    }

    @Override
    public char[] getChars(int line) {
        return this.fData.getChars(this.getPositionOfLine(line));
    }

    @Override
    public int getHeight() {
        return this.fHeight;
    }

    @Override
    public LineSegment[] getLineSegments(int line, int startCol, int numberOfCols) {
        this.validateLineParameter(line);
        return this.fData.getLineSegments(this.getPositionOfLine(line), startCol, numberOfCols);
    }

    @Override
    public int getMaxHeight() {
        return this.fMaxHeight;
    }

    @Override
    public TerminalStyle getStyle(int line, int column) {
        this.validateLineParameter(line);
        return this.fData.getStyle(this.getPositionOfLine(line), column);
    }

    @Override
    public TerminalStyle[] getStyles(int line) {
        this.validateLineParameter(line);
        return this.fData.getStyles(this.getPositionOfLine(line));
    }

    @Override
    public int getWidth() {
        return this.fData.getWidth();
    }

    @Override
    public ITerminalTextDataSnapshot makeSnapshot() {
        return this.fData.makeSnapshot();
    }

    private void cleanLines(int line, int len) {
        int i = line;
        while (i < line + len) {
            this.fData.cleanLine(this.getPositionOfLine(i));
            ++i;
        }
    }

    @Override
    public void scroll(int startLine, int size, int shift) {
        if (startLine + size > this.getHeight()) {
            throw new IllegalArgumentException("Value of 'startLine'+'size' parameters must be valid line (range [0-" + this.getHeight() + "). Parameter values: 'startLine'=" + startLine + ", 'size'=" + size);
        }
        if (shift >= this.fMaxHeight || -shift >= this.fMaxHeight) {
            this.cleanLines(startLine, this.fMaxHeight - startLine);
            return;
        }
        if (size == this.fHeight) {
            this.moveOffset(-shift);
            if (shift < 0) {
                this.cleanLines(Math.max(startLine, startLine + size + shift), Math.min(-shift, this.getHeight() - startLine));
            } else {
                this.cleanLines(startLine, Math.min(shift, this.getHeight() - startLine));
            }
        } else if (shift < 0) {
            int i = startLine;
            while (i < startLine + size + shift) {
                this.fData.copyLine(this.fData, this.getPositionOfLine(i - shift), this.getPositionOfLine(i));
                ++i;
            }
            this.cleanLines(Math.max(0, startLine + size + shift), Math.min(-shift, this.getHeight() - startLine));
        } else {
            int i = startLine + size - 1;
            while (i >= startLine && i - shift >= 0) {
                this.fData.copyLine(this.fData, this.getPositionOfLine(i - shift), this.getPositionOfLine(i));
                --i;
            }
            this.cleanLines(startLine, Math.min(shift, this.getHeight() - startLine));
        }
    }

    @Override
    public void setChar(int line, int column, char c, TerminalStyle style) {
        this.validateLineParameter(line);
        this.fData.setChar(this.getPositionOfLine(line), column, c, style);
    }

    @Override
    public void setChars(int line, int column, char[] chars, int start, int len, TerminalStyle style) {
        this.validateLineParameter(line);
        this.fData.setChars(this.getPositionOfLine(line), column, chars, start, len, style);
    }

    @Override
    public void setChars(int line, int column, char[] chars, TerminalStyle style) {
        this.validateLineParameter(line);
        this.fData.setChars(this.getPositionOfLine(line), column, chars, style);
    }

    @Override
    public void setDimensions(int height, int width) {
        if (height < 0) {
            throw new IllegalArgumentException("Parameter 'height' can't be negative value:" + height);
        }
        if (width < 0) {
            throw new IllegalArgumentException("Parameter 'width' can't be negative value:" + width);
        }
        if (height > this.fMaxHeight) {
            this.setMaxHeight(height);
        }
        this.fHeight = height;
        if (width != this.fData.getWidth()) {
            this.fData.setDimensions(this.fMaxHeight, width);
        }
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        if (maxHeight < this.fHeight) {
            throw new IllegalArgumentException("Parameter 'maxHeight' (value '" + maxHeight + "') must't be less than 'fHeight' (value '" + this.fHeight + "')");
        }
        int start = this.getPositionOfLine(0);
        if (start != 0) {
            TerminalTextDataStore buffer = new TerminalTextDataStore();
            buffer.setDimensions(maxHeight, this.getWidth());
            int n = Math.min(this.fMaxHeight - start, maxHeight);
            buffer.copyRange(this.fData, start, 0, n);
            if (n < maxHeight) {
                buffer.copyRange(this.fData, 0, n, Math.min(this.fMaxHeight - n, maxHeight - n));
            }
            this.fData.copy(buffer);
            this.moveOffset(-start);
        } else {
            this.fData.setDimensions(maxHeight, this.fData.getWidth());
        }
        this.fMaxHeight = maxHeight;
    }

    @Override
    public int getCursorColumn() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCursorLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorColumn(int column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorLine(int line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrappedLine(int line) {
        this.validateLineParameter(line);
        return this.fData.isWrappedLine(this.getPositionOfLine(line));
    }

    private void validateLineParameter(int line) {
        if (line < 0 || line >= this.fHeight) {
            throw new IllegalArgumentException("Parameter 'line' must be >= 0 and less than 'width' (current value '" + this.fHeight + "')");
        }
    }

    @Override
    public void setWrappedLine(int line) {
        this.validateLineParameter(line);
        this.fData.setWrappedLine(this.getPositionOfLine(line));
    }
}

