/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountStorageManager;

public class RegistryAccountManager {
    private static RegistryAccountManager instance;
    private RegistryAccountStorageManager storageManager = new RegistryAccountStorageManager();
    private List<IRegistryAccount> registryAccounts;

    private RegistryAccountManager() {
    }

    public static RegistryAccountManager getInstance() {
        if (instance == null) {
            instance = new RegistryAccountManager();
        }
        return instance;
    }

    public void setStorageManager(RegistryAccountStorageManager storageManager) {
        this.storageManager = storageManager;
        this.registryAccounts = storageManager.getAccounts();
    }

    public RegistryAccountStorageManager getStorageManager() {
        return this.storageManager;
    }

    public List<IRegistryAccount> getAccounts() {
        if (this.registryAccounts == null) {
            this.registryAccounts = this.storageManager.getAccounts();
        }
        return Collections.unmodifiableList(this.registryAccounts);
    }

    public IRegistryAccount getAccount(String serverAddress, String username) {
        return this.getAccounts().stream().filter(a -> a.getServerAddress().equals(serverAddress) && a.getUsername().equals(username)).findFirst().orElse(null);
    }

    public void add(IRegistryAccount info) {
        this.registryAccounts.add(info);
        this.storageManager.add(info);
    }

    public void remove(IRegistryAccount info) {
        this.registryAccounts.remove(info);
        this.storageManager.remove(info);
    }
}

