/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.internal;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.mediawiki.PageMapping;
import org.eclipse.mylyn.wikitext.mediawiki.Template;
import org.eclipse.mylyn.wikitext.mediawiki.TemplateResolver;
import org.eclipse.mylyn.wikitext.mediawiki.internal.MediaWikiIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.mediawiki.internal.TemplateProcessor;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;

public abstract class AbstractMediaWikiLanguage
extends AbstractMarkupLanguage {
    private static final String CATEGORY_PREFIX = ":";
    private static final Pattern STANDARD_EXTERNAL_LINK_FORMAT = Pattern.compile(".*?/([^/]+)/(\\{\\d+\\})");
    private static final Pattern QUALIFIED_INTERNAL_LINK = Pattern.compile("([^/]+)/(.+)");
    private PageMapping pageMapping;
    private Map<String, String> imageMapping;

    protected String mapPageNameToHref(String pageName) {
        Matcher matcher;
        Object pageId;
        String mapping;
        if (this.pageMapping != null && (mapping = this.pageMapping.mapPageNameToHref(pageName)) != null) {
            return mapping;
        }
        int anchorIndex = pageName.indexOf("#");
        if (anchorIndex < 0) {
            pageId = pageName;
        } else {
            String encodedAnchor = MediaWikiIdGenerationStrategy.headingTextToId(pageName.substring(anchorIndex + 1));
            pageId = pageName.substring(0, anchorIndex) + "#" + encodedAnchor;
        }
        if (((String)pageId).startsWith(CATEGORY_PREFIX) && ((String)pageId).length() > CATEGORY_PREFIX.length()) {
            return ((String)pageId).substring(CATEGORY_PREFIX.length());
        }
        if (((String)pageId).startsWith("#")) {
            return pageId;
        }
        if (this.internalLinkPattern.contains("index.php?")) {
            pageId = URLEncoder.encode((String)pageId, StandardCharsets.UTF_8);
        }
        if (QUALIFIED_INTERNAL_LINK.matcher((CharSequence)pageId).matches() && (matcher = STANDARD_EXTERNAL_LINK_FORMAT.matcher(this.internalLinkPattern)).matches()) {
            String prefix = matcher.group(1);
            if (((String)pageId).startsWith(prefix + "/")) {
                return this.internalLinkPattern.substring(0, matcher.start(1)) + (String)pageId;
            }
            return this.internalLinkPattern.substring(0, matcher.start(2)) + (String)pageId;
        }
        return MessageFormat.format(this.internalLinkPattern, pageId);
    }

    public PageMapping getPageMapping() {
        return this.pageMapping;
    }

    public void setPageMapping(PageMapping pageMapping) {
        this.pageMapping = pageMapping;
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        if (this.isEnableMacros()) {
            markupContent = this.preprocessContent(markupContent);
        }
        super.processContent(parser, markupContent, asDocument);
    }

    private String preprocessContent(String markupContent) {
        return new TemplateProcessor(this).processTemplates(markupContent);
    }

    public abstract List<Template> getTemplates();

    public abstract List<TemplateResolver> getTemplateProviders();

    public abstract String getTemplateExcludes();

    public Set<String> getImageNames() {
        if (this.imageMapping == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(this.imageMapping.values()));
    }

    public void setImageNames(Set<String> imageNames) {
        if (this.imageMapping == null) {
            this.imageMapping = new HashMap<String, String>();
        } else {
            this.imageMapping.clear();
        }
        for (String name : imageNames) {
            this.imageMapping.put(name.toLowerCase(), name);
        }
    }

    public String mapImageName(String imageName) {
        String substitute;
        String string = substitute = this.imageMapping == null ? null : this.imageMapping.get(imageName.toLowerCase());
        if (substitute != null) {
            imageName = substitute;
        }
        return imageName;
    }

    public MarkupLanguage clone() {
        AbstractMediaWikiLanguage copy = (AbstractMediaWikiLanguage)super.clone();
        copy.imageMapping = this.imageMapping;
        copy.pageMapping = this.pageMapping;
        return copy;
    }
}

