/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.uriresolver.URIHelper;
import org.eclipse.wst.internet.cache.internal.CacheEntry;
import org.eclipse.wst.internet.cache.internal.CacheJob;
import org.eclipse.wst.internet.cache.internal.CachePlugin;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Cache {
    private static final String URI = "uri";
    private static final String LOCATION = "location";
    private static final String ENTRY = "entry";
    private static final String CACHE = "cache";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String EXPIRATION_TIME = "expirationTime";
    private static final String FILE_PROTOCOL = "file:///";
    private static final String CACHE_FILE = "cache.xml";
    private static final String CACHE_EXTENSION = ".cache";
    private static final String CACHE_PREFIX = "wtpcache";
    private static final String CACHE_SUFFIX = null;
    private static Cache cacheInstance = null;
    private Hashtable cache;
    private Set uncached;
    private File cacheLocation = null;

    protected Cache(IPath cacheLocation) {
        this.cacheLocation = cacheLocation.toFile();
        this.cache = new Hashtable();
        this.uncached = new HashSet();
    }

    public static Cache getInstance() {
        return cacheInstance;
    }

    public String getResource(String uri) {
        if (uri == null) {
            return null;
        }
        CacheEntry result = (CacheEntry)this.cache.get(uri);
        if (result == null) {
            if (!this.uncached.contains(uri)) {
                result = this.cacheResource(uri);
            }
        } else if (result.hasExpired()) {
            result = this.refreshCacheEntry(result);
        }
        if (result == null || result.getLocalFile() == null) {
            return null;
        }
        return FILE_PROTOCOL + this.cacheLocation.toString() + "/" + result.getLocalFile();
    }

    private static long getTimeout() {
        return CachePlugin.getDefault().getCacheTimeout() * 60000L;
    }

    protected String[] getUncachedURIs() {
        return this.uncached.toArray(new String[this.uncached.size()]);
    }

    protected void clearUncachedURIs() {
        this.uncached.clear();
    }

    protected void addUncachedURI(String uri) {
        CacheJob.startJob();
        this.uncached.add(uri);
    }

    protected CacheEntry cacheResource(String uri) {
        CacheEntry cacheEntry;
        block35: {
            OutputStream os;
            InputStream is;
            block32: {
                URLConnection conn;
                block33: {
                    CacheEntry cacheEntry2;
                    block34: {
                        cacheEntry = null;
                        is = null;
                        os = null;
                        String actualUri = uri;
                        URL url = new URL(actualUri);
                        conn = url.openConnection();
                        int allowedRedirects = 5;
                        while (conn.getHeaderField("Location") != null && allowedRedirects > 0) {
                            --allowedRedirects;
                            actualUri = conn.getHeaderField("Location");
                            url = new URL(actualUri);
                            conn = url.openConnection();
                        }
                        if (!CachePlugin.getDefault().isIgnoreNoCacheHeader() && !conn.getUseCaches()) break block32;
                        is = URIHelper.getInputStream((String)actualUri, (int)0);
                        if (is != null) break block33;
                        this.uncached.add(uri);
                        cacheEntry2 = cacheEntry;
                        if (is == null) break block34;
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return cacheEntry2;
                }
                try {
                    try {
                        int bytelength;
                        Random rand = new Random();
                        String fileName = Math.abs(rand.nextInt()) + CACHE_EXTENSION;
                        File file = new File(this.cacheLocation, fileName);
                        while (!file.createNewFile()) {
                            fileName = Math.abs(rand.nextInt()) + CACHE_EXTENSION;
                            file = new File(this.cacheLocation, fileName);
                        }
                        os = new BufferedOutputStream(new FileOutputStream(file));
                        byte[] bytes = new byte[1024];
                        while ((bytelength = is.read(bytes)) != -1) {
                            os.write(bytes, 0, bytelength);
                        }
                        long lastModified = conn.getLastModified();
                        long expiration = conn.getExpiration();
                        if (expiration == 0L) {
                            expiration = System.currentTimeMillis() + Cache.getTimeout();
                        }
                        cacheEntry = new CacheEntry(uri, fileName, lastModified, expiration);
                        this.cache.put(uri, cacheEntry);
                    }
                    catch (Exception exception) {
                        this.addUncachedURI(uri);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return cacheEntry;
    }

    protected CacheEntry refreshCacheEntry(CacheEntry cacheEntry) {
        block28: {
            URLConnection conn = null;
            InputStream is = null;
            OutputStream os = null;
            try {
                try {
                    URL url = new URL(cacheEntry.getURI());
                    conn = url.openConnection();
                    conn.connect();
                    long lastModified = conn.getLastModified();
                    if (lastModified > cacheEntry.getLastModified()) {
                        int bytelength;
                        long expiration = conn.getExpiration();
                        if (expiration == 0L) {
                            expiration = System.currentTimeMillis() + Cache.getTimeout();
                        }
                        is = conn.getInputStream();
                        String localFile = cacheEntry.getLocalFile();
                        File tempFile = File.createTempFile(CACHE_PREFIX, CACHE_SUFFIX);
                        tempFile.deleteOnExit();
                        os = new FileOutputStream(tempFile);
                        byte[] bytes = new byte[1024];
                        while ((bytelength = is.read(bytes)) != -1) {
                            os.write(bytes, 0, bytelength);
                        }
                        is.close();
                        os.close();
                        this.deleteFile(cacheEntry.getURI());
                        File f = new File(this.cacheLocation, localFile);
                        tempFile.renameTo(f);
                        cacheEntry.setExpiration(expiration);
                        cacheEntry.setLastModified(lastModified);
                    } else {
                        long expiration = conn.getExpiration();
                        if (expiration == 0L) {
                            expiration = System.currentTimeMillis() + Cache.getTimeout();
                        }
                        cacheEntry.setExpiration(expiration);
                    }
                }
                catch (Exception exception) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return cacheEntry;
    }

    public String[] getCachedURIs() {
        Set keyset = this.cache.keySet();
        return keyset.toArray(new String[keyset.size()]);
    }

    protected void close() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document cachedoc = builder.newDocument();
            Element rootelem = cachedoc.createElement(CACHE);
            cachedoc.appendChild(rootelem);
            Enumeration uris = this.cache.keys();
            while (uris.hasMoreElements()) {
                String key = (String)uris.nextElement();
                CacheEntry cacheEntry = (CacheEntry)this.cache.get(key);
                if (cacheEntry == null) continue;
                Element entry = cachedoc.createElement(ENTRY);
                entry.setAttribute(URI, key);
                entry.setAttribute(LOCATION, cacheEntry.getLocalFile());
                entry.setAttribute(EXPIRATION_TIME, String.valueOf(cacheEntry.getExpirationTime()));
                entry.setAttribute(LAST_MODIFIED, String.valueOf(cacheEntry.getLastModified()));
                rootelem.appendChild(entry);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource input = new DOMSource(cachedoc);
            IPath stateLocation = Platform.getStateLocation((Bundle)CachePlugin.getDefault().getBundle());
            StreamResult output = new StreamResult(stateLocation.toString() + "/cache.xml");
            transformer.transform(input, output);
        }
        catch (Exception exception) {
            System.err.println("Unable to store internet cache.");
        }
        cacheInstance = null;
    }

    protected static void open(IPath cacheLocation) {
        cacheInstance = new Cache(cacheLocation);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            IPath stateLocation = cacheLocation;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document cachedoc = builder.parse(stateLocation.toString() + "/cache.xml");
            Element rootelem = cachedoc.getDocumentElement();
            NodeList entries = rootelem.getChildNodes();
            int numEntries = entries.getLength();
            int i = 0;
            while (i < numEntries) {
                Element e;
                Node entry = entries.item(i);
                if (entry instanceof Element && (e = (Element)entry).getNodeName().equals(ENTRY)) {
                    String uri = e.getAttribute(URI);
                    String location = e.getAttribute(LOCATION);
                    String lm = e.getAttribute(LAST_MODIFIED);
                    String et = e.getAttribute(EXPIRATION_TIME);
                    long lastModified = -1L;
                    long expirationTime = -1L;
                    try {
                        lastModified = Long.parseLong(lm);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        expirationTime = Long.parseLong(et);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (uri != null && location != null) {
                        Cache.cacheInstance.cache.put(uri, new CacheEntry(uri, location, lastModified, expirationTime));
                    }
                }
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            System.out.println("Unable to load cache.");
        }
    }

    public void clear() {
        Enumeration keys = this.cache.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.deleteFile(key);
        }
        this.cache.clear();
    }

    public void deleteEntry(String uri) {
        if (uri == null) {
            return;
        }
        this.deleteFile(uri);
        this.cache.remove(uri);
    }

    protected void deleteFile(String uri) {
        String location;
        File file;
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(uri);
        if (cacheEntry != null && !(file = new File(location = this.cacheLocation.toString() + "/" + cacheEntry.getLocalFile())).delete()) {
            System.out.println("Unable to delete file " + location + " from cache.");
        }
    }
}

