/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.descriptors;

import java.util.ArrayList;
import org.eclipse.pde.api.tools.internal.descriptors.FieldDescriptorImpl;
import org.eclipse.pde.api.tools.internal.descriptors.MemberDescriptorImpl;
import org.eclipse.pde.api.tools.internal.descriptors.MethodDescriptorImpl;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;

public class ReferenceTypeDescriptorImpl
extends MemberDescriptorImpl
implements IReferenceTypeDescriptor {
    private String fFullName = null;
    private String fSignature = null;
    private String fGenericSignature = null;

    ReferenceTypeDescriptorImpl(String name, IElementDescriptor parent) {
        super(name, parent);
    }

    ReferenceTypeDescriptorImpl(String name, IElementDescriptor parent, String genericSignature) {
        this(name, parent);
        this.fGenericSignature = genericSignature;
    }

    @Override
    public IFieldDescriptor getField(String name) {
        return new FieldDescriptorImpl(name, this);
    }

    @Override
    public IMethodDescriptor getMethod(String name, String signature) {
        return new MethodDescriptorImpl(name, this, signature);
    }

    @Override
    public IReferenceTypeDescriptor getType(String simpleName) {
        return new ReferenceTypeDescriptorImpl(simpleName, this);
    }

    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public synchronized String getQualifiedName() {
        if (this.fFullName == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.getPackage().getName());
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            ArrayList<IReferenceTypeDescriptor> all = null;
            IReferenceTypeDescriptor enclosingType = this.getEnclosingType();
            while (enclosingType != null) {
                if (all == null) {
                    all = new ArrayList<IReferenceTypeDescriptor>();
                }
                all.add(0, enclosingType);
                enclosingType = enclosingType.getEnclosingType();
            }
            if (all != null) {
                for (IReferenceTypeDescriptor desc : all) {
                    buffer.append(desc.getName());
                    buffer.append('$');
                }
            }
            buffer.append(this.getName());
            this.fFullName = buffer.toString();
        }
        return this.fFullName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IReferenceTypeDescriptor) {
            IReferenceTypeDescriptor refType = (IReferenceTypeDescriptor)obj;
            return this.getQualifiedName().equals(refType.getQualifiedName());
        }
        return false;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    @Override
    public int compareTo(IElementDescriptor o) {
        if (o instanceof ReferenceTypeDescriptorImpl) {
            return this.getQualifiedName().compareTo(((ReferenceTypeDescriptorImpl)o).getQualifiedName());
        }
        if (ApiPlugin.DEBUG_ELEMENT_DESCRIPTOR_FRAMEWORK) {
            System.err.println(o.getClass());
        }
        return super.compareTo(o);
    }

    @Override
    public int getElementType() {
        return 2;
    }

    @Override
    public String getSignature() {
        if (this.fSignature == null) {
            StringBuilder buf = new StringBuilder();
            buf.append('L');
            buf.append(this.getQualifiedName());
            buf.append(';');
            this.fSignature = buf.toString();
        }
        return this.fSignature;
    }

    @Override
    public String getGenericSignature() {
        return this.fGenericSignature;
    }

    @Override
    public boolean isAnonymous() {
        if (this.getEnclosingType() != null) {
            try {
                Integer.parseInt(this.getName());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

