/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.progress;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.EvictingQueue;
import java.util.Queue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.gradle.tooling.ProgressEvent;
import org.gradle.tooling.ProgressListener;

public final class DelegatingProgressListener
implements ProgressListener {
    private final SubMonitor monitor;
    private final Predicate<? super ProgressEvent> eventFilter;

    private DelegatingProgressListener(IProgressMonitor monitor, Predicate<? super ProgressEvent> eventFilter) {
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor);
        this.eventFilter = (Predicate)Preconditions.checkNotNull(eventFilter);
    }

    public void statusChanged(ProgressEvent event) {
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!this.eventFilter.apply((Object)event)) {
            return;
        }
        this.monitor.setWorkRemaining(100);
        this.monitor.worked(1);
        this.monitor.subTask(event.getDescription());
    }

    public static ProgressListener withFullOutput(IProgressMonitor monitor) {
        return new DelegatingProgressListener(monitor, (Predicate<? super ProgressEvent>)Predicates.alwaysTrue());
    }

    public static ProgressListener withoutDuplicateLifecycleEvents(IProgressMonitor monitor) {
        Predicate<ProgressEvent> withoutDuplicates = new Predicate<ProgressEvent>(){
            final Queue<String> recentlySeen = EvictingQueue.create((int)10);

            public boolean apply(ProgressEvent event) {
                String description = event.getDescription();
                boolean shouldShow = !this.recentlySeen.contains(description);
                this.recentlySeen.add(description);
                return shouldShow;
            }
        };
        return new DelegatingProgressListener(monitor, (Predicate<? super ProgressEvent>)withoutDuplicates);
    }
}

