/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap.generator;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.JavaUtils;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectType;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMap;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMapReference;
import org.eclipse.scout.sdk.core.s.widgetmap.ObjectType;
import org.eclipse.scout.sdk.core.s.widgetmap.Type;
import org.eclipse.scout.sdk.core.typescript.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.CompositeTypeGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.ICompositeTypeGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.IDataTypeGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.TypeAliasGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.typescript.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.util.Ensure;

public class IdObjectTypeMapGenerator
extends TypeAliasGenerator<IdObjectTypeMapGenerator> {
    private IdObjectTypeMap m_map;

    protected void setup() {
        IdObjectTypeMap map = this.map().orElseThrow(() -> Ensure.newFail((CharSequence)"IdObjectTypeMap missing.", (Object[])new Object[0]));
        ((IdObjectTypeMapGenerator)this.withModifier(Modifier.EXPORT)).withElementName(Type.ensureValidName(map.name()));
        ICompositeTypeGenerator intersection = CompositeTypeGenerator.create().withFlavor(IDataType.DataTypeFlavor.Intersection);
        if (!map.elements().isEmpty()) {
            ITypeGenerator objectType = TypeGenerator.create();
            Stream<IFieldGenerator> stream = map.elements().values().stream().map(this::createIdObjectTypeField);
            ITypeGenerator iTypeGenerator = objectType;
            Objects.requireNonNull(iTypeGenerator);
            ITypeGenerator iTypeGenerator2 = iTypeGenerator;
            stream.forEach(x$0 -> iTypeGenerator2.withField(x$0, new Object[0]));
            intersection.withType((ISourceGenerator)objectType);
        }
        map.idObjectTypeMapReferences().stream().map(IdObjectTypeMapReference::reference).forEach(ref -> intersection.withType(b -> b.ref(ref)));
        this.withAliasedType((IDataTypeGenerator)intersection);
    }

    protected IFieldGenerator<?> createIdObjectTypeField(IdObjectType idObjectType) {
        ObjectType objectType = idObjectType.objectType();
        IObjectLiteral objectLiteral = this.m_map.model();
        IES6Class es6Class = objectType.es6Class();
        IDataType dataType = objectType.newClassName().map(name -> objectLiteral.spi().createDataType(name).api()).orElseGet(() -> {
            long typeParameterCount = es6Class.typeParameters().map(ITypeParameter::defaultConstraint).filter(Optional::isEmpty).count();
            if (typeParameterCount < 1L) {
                return es6Class;
            }
            List<IDataType> typeArgs = Stream.generate(() -> "any").limit(typeParameterCount).map(any -> objectLiteral.spi().createDataType(any).api()).toList();
            return es6Class.containingModule().nodeElementFactory().createClassWithTypeArguments(es6Class, typeArgs);
        });
        String id = JavaUtils.toStringLiteral((CharSequence)idObjectType.id(), (CharSequence)"'", (boolean)true).toString();
        return ((IFieldGenerator)FieldGenerator.create().withElementName(id)).withDataType(dataType);
    }

    public Optional<IdObjectTypeMap> map() {
        return Optional.ofNullable(this.m_map);
    }

    public IdObjectTypeMapGenerator withMap(IdObjectTypeMap map) {
        this.m_map = map;
        return this;
    }
}

