/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editpolicies;

import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAttributeAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDElementDeclarationAdapter;
import org.eclipse.wst.xsd.ui.internal.commands.BaseDragAndDropCommand;
import org.eclipse.wst.xsd.ui.internal.commands.XSDAttributeDragAndDropCommand;
import org.eclipse.wst.xsd.ui.internal.commands.XSDElementDragAndDropCommand;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDBaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.SelectionHandlesEditPolicyImpl;

public class DragAndDropEditPolicy
extends GraphicalEditPolicy {
    protected EditPartViewer viewer;
    protected SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy;

    public DragAndDropEditPolicy(EditPartViewer viewer, SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy) {
        this.viewer = viewer;
        this.selectionHandlesEditPolicy = selectionHandlesEditPolicy;
    }

    public boolean understandsRequest(Request req) {
        return true;
    }

    public Command getCommand(Request request) {
        BaseDragAndDropCommand command = null;
        if (request instanceof ChangeBoundsRequest) {
            Object itemToDrag;
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            Point location = changeBoundsRequest.getLocation();
            GraphicalEditPart target = (GraphicalEditPart)this.viewer.findObjectAt(location);
            location = this.getPointerLocation(changeBoundsRequest.getLocation());
            ((GraphicalEditPart)this.viewer.getRootEditPart()).getFigure().translateToRelative((Translatable)location);
            List list = changeBoundsRequest.getEditParts();
            if (list.size() == 1 && (itemToDrag = list.get(0)) instanceof XSDBaseFieldEditPart) {
                XSDBaseFieldEditPart selected = (XSDBaseFieldEditPart)itemToDrag;
                if (selected.getModel() instanceof XSDElementDeclarationAdapter) {
                    command = new XSDElementDragAndDropCommand(this.viewer, (ChangeBoundsRequest)request, target, selected, location);
                    this.selectionHandlesEditPolicy.setDragAndDropCommand(command);
                } else if (selected.getModel() instanceof XSDBaseAttributeAdapter) {
                    command = new XSDAttributeDragAndDropCommand(this.viewer, (ChangeBoundsRequest)request, target, selected, location);
                    this.selectionHandlesEditPolicy.setDragAndDropCommand(command);
                }
            }
        }
        return command;
    }

    protected Point getPointerLocation(Point origPointerLocation) {
        Point compensatedLocation = origPointerLocation;
        FigureCanvas figureCanvas = (FigureCanvas)this.viewer.getControl();
        int yOffset = figureCanvas.getViewport().getVerticalRangeModel().getValue();
        int xOffset = figureCanvas.getViewport().getHorizontalRangeModel().getValue();
        compensatedLocation.y += yOffset;
        compensatedLocation.x += xOffset;
        return compensatedLocation;
    }
}

