/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.sourcelookup;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.core.model.GroupedStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.LambdaUtils;
import org.eclipse.jdt.internal.debug.ui.sourcelookup.LambdaStackFrameSourceDisplayAdapter;
import org.eclipse.jdt.internal.debug.ui.sourcelookup.StackFrameShowInSourceAdapter;
import org.eclipse.jdt.internal.debug.ui.sourcelookup.StackFrameShowInTargetListAdapter;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;

public class JavaDebugShowInAdapterFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == IShowInSource.class && adaptableObject instanceof IJavaStackFrame) {
            IJavaStackFrame frame = (IJavaStackFrame)adaptableObject;
            return (T)new StackFrameShowInSourceAdapter(frame);
        }
        if (adapterType == IShowInTargetList.class && adaptableObject instanceof IJavaStackFrame) {
            return (T)new StackFrameShowInTargetListAdapter();
        }
        if (adapterType == ISourceDisplay.class) {
            if (adaptableObject instanceof GroupedStackFrame) {
                GroupedStackFrame groupedFrames = (GroupedStackFrame)adaptableObject;
                return (T)((ISourceDisplay)(element, page, forceSourceLookup) -> {
                    IJavaStackFrame frame = groupedFrames.getTopMostFrame();
                    SourceLookupFacility.getDefault().displaySource((Object)frame, page, forceSourceLookup);
                });
            }
            try {
                JDIStackFrame jdiFrame;
                if (adaptableObject instanceof JDIStackFrame && LambdaUtils.isLambdaFrame((IJavaStackFrame)(jdiFrame = (JDIStackFrame)adaptableObject))) {
                    return (T)new LambdaStackFrameSourceDisplayAdapter();
                }
            }
            catch (DebugException e) {
                DebugUIPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IShowInSource.class, IShowInTargetList.class, ISourceDisplay.class};
    }
}

