/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.ajax.JSON;

public class JSONObjectConvertor
implements JSON.Convertor {
    private final boolean _fromJSON;
    private final Set<String> _excluded;

    public JSONObjectConvertor() {
        this(false);
    }

    public JSONObjectConvertor(boolean fromJSON) {
        this(fromJSON, null);
    }

    public JSONObjectConvertor(boolean fromJSON, String[] excludedFieldNames) {
        this._fromJSON = fromJSON;
        this._excluded = excludedFieldNames == null ? Set.of() : Set.of(excludedFieldNames);
    }

    @Override
    public Object fromJSON(Map<String, Object> map) {
        if (this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        return map;
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        try {
            Class<?> c = obj.getClass();
            if (this._fromJSON) {
                out.addClass(c);
            }
            for (Method m : c.getMethods()) {
                if (Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 0 || m.getReturnType() == null || m.getDeclaringClass() == Object.class) continue;
                Object name = m.getName();
                if (((String)name).startsWith("is")) {
                    name = ((String)name).substring(2, 3).toLowerCase(Locale.ENGLISH) + ((String)name).substring(3);
                } else {
                    if (!((String)name).startsWith("get")) continue;
                    name = ((String)name).substring(3, 4).toLowerCase(Locale.ENGLISH) + ((String)name).substring(4);
                }
                if (!this.includeField((String)name, obj, m)) continue;
                out.add((String)name, m.invoke(obj, (Object[])null));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected boolean includeField(String name, Object o, Method m) {
        return !this._excluded.contains(name);
    }
}

