/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.util.collection.Pair;

public class LoadPermissionsIndication
extends CDOServerReadIndication {
    private Map<CDOBranchPoint, Pair<CDOID[], CDOPermission[]>> permissionsBySecurityContext;
    private int referenceChunk;

    public LoadPermissionsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)55);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        int mapSize = in.readXInt();
        this.permissionsBySecurityContext = new HashMap<CDOBranchPoint, Pair<CDOID[], CDOPermission[]>>(mapSize);
        int m = 0;
        while (m < mapSize) {
            CDOBranchPoint securityContext = in.readCDOBranchPoint();
            int listSize = in.readXInt();
            CDOID[] ids = new CDOID[listSize];
            CDOPermission[] oldPermissions = new CDOPermission[listSize];
            this.permissionsBySecurityContext.put(securityContext, (Pair<CDOID[], CDOPermission[]>)Pair.create((Object)ids, (Object)oldPermissions));
            int i = 0;
            while (i < listSize) {
                ids[i] = in.readCDOID();
                oldPermissions[i] = CDOPermission.get((int)in.readByte());
                ++i;
            }
            ++m;
        }
        this.referenceChunk = in.readXInt();
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalSession session = this.getSession();
        InternalRepository repository = this.getRepository();
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        IPermissionManager permissionManager = repository.getSessionManager().getPermissionManager();
        for (Map.Entry<CDOBranchPoint, Pair<CDOID[], CDOPermission[]>> entry : this.permissionsBySecurityContext.entrySet()) {
            CDOBranchPoint securityContext = entry.getKey();
            Pair<CDOID[], CDOPermission[]> value = entry.getValue();
            CDOID[] ids = (CDOID[])value.getElement1();
            CDOPermission[] oldPermissions = (CDOPermission[])value.getElement2();
            int listSize = ids.length;
            int i = 0;
            while (i < listSize) {
                CDOID id = ids[i];
                CDOPermission oldPermission = oldPermissions[i];
                InternalCDORevision revision = revisionManager.getRevision(id, securityContext, 0, 0, true);
                if (revision == null) {
                    out.writeByte(-1);
                } else {
                    CDOPermission newPermission = permissionManager.getPermission((CDORevision)revision, securityContext, (ISession)session);
                    out.writeByte((int)newPermission.getBits());
                    if (oldPermission == CDOPermission.NONE && newPermission != CDOPermission.NONE) {
                        revision.writeValues(out, this.referenceChunk);
                    }
                }
                ++i;
            }
        }
    }
}

