/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.util.css.editor;

import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.wikitext.ui.util.css.editor.Colors;
import org.eclipse.mylyn.internal.wikitext.ui.util.css.editor.CommentDamagerRepairer;
import org.eclipse.mylyn.internal.wikitext.ui.util.css.editor.CssBlockScanner;
import org.eclipse.mylyn.internal.wikitext.ui.util.css.editor.CssScanner;
import org.eclipse.swt.graphics.RGB;

public class CssConfiguration
extends SourceViewerConfiguration {
    private final ColorRegistry colorRegistry;

    public CssConfiguration(ColorRegistry colorRegistry) {
        this.colorRegistry = colorRegistry;
        for (Map.Entry<String, RGB> colorEnt : Colors.keyToRgb.entrySet()) {
            colorRegistry.put(colorEnt.getKey(), colorEnt.getValue());
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__css_comment", "__css_block"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getCssTokenScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__css_block");
        reconciler.setRepairer((IPresentationRepairer)dr, "__css_block");
        dr = new DefaultDamagerRepairer(this.getCssScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        CommentDamagerRepairer commentDamagerRepairer = new CommentDamagerRepairer(new TextAttribute(this.colorRegistry.get("css.comment")));
        reconciler.setDamager((IPresentationDamager)commentDamagerRepairer, "__css_comment");
        reconciler.setRepairer((IPresentationRepairer)commentDamagerRepairer, "__css_comment");
        return reconciler;
    }

    private ITokenScanner getCssScanner() {
        return new CssScanner(this.colorRegistry);
    }

    private ITokenScanner getCssTokenScanner() {
        return new CssBlockScanner(this.colorRegistry);
    }
}

