/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.handlers;

import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.core.ISessionManager;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SelectActiveSessionsItems
extends ContributionItem {
    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        ISessionManager sm = CoverageTools.getSessionManager();
        ICoverageSession activeSession = sm.getActiveSession();
        int position = 1;
        for (ICoverageSession session : sm.getSessions()) {
            this.createItem(menu, index++, session, session == activeSession, position++, sm);
        }
    }

    private void createItem(Menu parent, int index, final ICoverageSession session, boolean selected, int position, final ISessionManager sm) {
        MenuItem item = new MenuItem(parent, 16, index);
        item.setImage(EclEmmaUIPlugin.getImage("icons/full/elcl16/session.png"));
        item.setText(this.getLabel(session, position));
        item.setSelection(selected);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sm.activateSession(session);
            }
        });
    }

    private String getLabel(ICoverageSession session, int idx) {
        return NLS.bind((String)UIMessages.CoverageViewSelectSessionMenu_label, (Object)idx, (Object)session.getDescription());
    }
}

