/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.internal.core.BuildPackage;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.IBuildLoader;
import org.eclipse.mylyn.builds.internal.core.util.Messages;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.osgi.util.NLS;

public class BuildModelManager {
    private final Resource resource;
    private final BuildModel model;
    private final IBuildLoader buildLoader;

    public BuildModelManager(File file, IBuildLoader buildLoader) {
        this.buildLoader = buildLoader;
        Resource resource = null;
        BuildModel model = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        URI uri = URI.createURI((String)file.toURI().toString());
        if (file.exists()) {
            try {
                resource = resourceSet.getResource(uri, true);
                Object root = resource.getContents().get(0);
                if (root instanceof BuildModel) {
                    model = (BuildModel)root;
                    for (IBuildServer server : model.getServers()) {
                        ((BuildServer)server).setLoader(buildLoader);
                        Map<String, String> properties = ((BuildServer)server).getAttributes();
                        if (properties.size() <= 0) continue;
                        ((BuildServer)server).setLocation(new RepositoryLocation(properties));
                    }
                } else {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", NLS.bind((String)Messages.BuildModelManager_unexpectedContent, (Object)file.getAbsolutePath())));
                }
            }
            catch (RuntimeException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", NLS.bind((String)Messages.BuildModelManager_unexpectedError, (Object)file.getAbsolutePath()), (Throwable)e));
            }
        }
        if (model == null) {
            resource = resourceSet.createResource(uri);
            model = (BuildModel)BuildPackage.eINSTANCE.getBuildFactory().createBuildModel();
            resource.getContents().clear();
            resource.getContents().add((Object)model);
        }
        this.model = model;
        this.resource = resource;
    }

    public void save() throws IOException {
        List<IBuildServer> servers = this.model.getServers();
        ArrayList<IBuild> builds = new ArrayList<IBuild>();
        ArrayList<IBuildPlan> danglingPlans = new ArrayList<IBuildPlan>();
        List<IBuildPlan> plans = this.model.getPlans();
        for (IBuildPlan plan : plans) {
            if (!servers.contains(plan.getServer())) {
                danglingPlans.add(plan);
                continue;
            }
            if (plan.getLastBuild() == null) continue;
            builds.add(plan.getLastBuild());
        }
        plans.removeAll(danglingPlans);
        this.model.getBuilds().clear();
        this.model.getBuilds().addAll(builds);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        this.resource.save(options);
    }

    public BuildModel getModel() {
        return this.model;
    }

    public IBuildServer createServer(String connectorKind, RepositoryLocation location) {
        BuildServer server = (BuildServer)BuildPackage.eINSTANCE.getBuildFactory().createBuildServer();
        server.setConnectorKind(connectorKind);
        server.setLocation(location);
        server.setLoader(this.buildLoader);
        return server;
    }
}

