/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.Objects;

public class JUnitRuntimeClasspathEntry {
    private final String fPluginId;
    private final String fPluginRelativePath;
    private final String fVersion;

    public JUnitRuntimeClasspathEntry(String pluginId, String jarFile) {
        this(pluginId, jarFile, null);
    }

    public JUnitRuntimeClasspathEntry(String pluginId, String jarFile, String version) {
        this.fPluginId = pluginId;
        this.fPluginRelativePath = jarFile;
        this.fVersion = version;
    }

    public String getPluginId() {
        return this.fPluginId;
    }

    public String getPluginRelativePath() {
        return this.fPluginRelativePath;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public JUnitRuntimeClasspathEntry developmentModeEntry() {
        return new JUnitRuntimeClasspathEntry(this.getPluginId(), "bin", this.getVersion());
    }

    public String toString() {
        return "ClasspathEntry(" + this.fPluginId + "/" + this.fPluginRelativePath + "[" + this.fVersion + "])";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JUnitRuntimeClasspathEntry)) {
            return false;
        }
        JUnitRuntimeClasspathEntry other = (JUnitRuntimeClasspathEntry)obj;
        if (!this.fPluginId.equals(other.getPluginId())) {
            return false;
        }
        if (!Objects.equals(this.fPluginRelativePath, other.getPluginRelativePath())) {
            return false;
        }
        return Objects.equals(this.fVersion, other.getVersion());
    }

    public int hashCode() {
        return Objects.hash(this.fPluginId, this.fPluginRelativePath, this.fVersion);
    }
}

