/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.confluence.internal.block.ParameterizedBlock;

public abstract class AbstractConfluenceDelimitedBlock
extends ParameterizedBlock {
    private final Pattern startPattern;
    private final Pattern endPattern;
    protected int blockLineCount = 0;
    private Matcher matcher;

    public AbstractConfluenceDelimitedBlock(String blockName) {
        this.startPattern = Pattern.compile("\\s*\\{" + blockName + "(?::([^\\}]*))?\\}(.*)");
        this.endPattern = Pattern.compile("\\s*(\\{" + blockName + "\\})(.*)");
    }

    public int processLineContent(String line, int offset) {
        int endOfContent;
        if (this.blockLineCount == 0) {
            this.setOptions(this.matcher.group(1));
            offset = this.matcher.start(2);
            this.beginBlock();
        }
        int segmentEnd = endOfContent = line.length();
        boolean terminating = false;
        if (offset < endOfContent) {
            Matcher endMatcher = this.endPattern.matcher(line);
            if (this.blockLineCount == 0) {
                endMatcher.region(offset, endOfContent);
            }
            if (endMatcher.find()) {
                terminating = true;
                endOfContent = endMatcher.start(2);
                segmentEnd = endMatcher.start(1);
            }
        }
        if (endOfContent < line.length()) {
            this.state.setLineSegmentEndOffset(endOfContent);
        }
        ++this.blockLineCount;
        String content = line.substring(offset, segmentEnd);
        int contentOffset = this.handleBlockContent(content);
        if (terminating) {
            this.setClosed(true);
        }
        return this.finalOffset(line.length(), endOfContent, contentOffset, offset);
    }

    private int finalOffset(int lineLength, int endOfContent, int contentOffset, int initialOffset) {
        int finalOffset;
        int n = finalOffset = contentOffset == -1 ? -1 : initialOffset + contentOffset;
        if (finalOffset == lineLength) {
            finalOffset = -1;
        } else if (endOfContent != lineLength) {
            finalOffset = endOfContent;
        }
        return finalOffset;
    }

    protected abstract int handleBlockContent(String var1);

    protected abstract void beginBlock();

    protected abstract void endBlock();

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.endBlock();
        }
        super.setClosed(closed);
    }

    public boolean canStart(String line, int lineOffset) {
        this.resetState();
        this.matcher = this.startPattern.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        return this.matcher.matches();
    }

    protected void resetState() {
        this.blockLineCount = 0;
    }
}

