/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.richstring.RichStringProcessor;
import org.eclipse.xtend.core.typesystem.LocalClassAwareTypeNames;
import org.eclipse.xtend.core.validation.AnnotationValidation;
import org.eclipse.xtend.core.validation.ModifierValidator;
import org.eclipse.xtend.core.validation.ValidatingRichStringAcceptor;
import org.eclipse.xtend.core.validation.XtendJvmGenericTypeValidator;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringElseIf;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFormalParameter;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.core.xtend.XtendVariableDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.validation.XbaseWithAnnotationsValidator;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.validation.ImplicitReturnFinder;
import org.eclipse.xtext.xbase.validation.ProxyAwareUIStrings;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XImportDeclaration;

@ComposedChecks(validators={AnnotationValidation.class, XtendJvmGenericTypeValidator.class})
public class XtendValidator
extends XbaseWithAnnotationsValidator {
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private XAnnotationUtil annotationUtil;
    @Inject
    private JavaKeywords javaUtils;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private OperatorMapping operatorMapping;
    @Inject
    private ImplicitReturnFinder implicitReturnFinder;
    @Inject
    private LocalClassAwareTypeNames localClassAwareTypeNames;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private ProxyAwareUIStrings proxyAwareUIStrings;
    @Inject
    private AnnotationLookup annotationLookup;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    protected final Set<String> visibilityModifers = ImmutableSet.of((Object)"public", (Object)"private", (Object)"protected", (Object)"package");
    protected final Set<String> junitAnnotations = ImmutableSet.of((Object)"org.junit.Test", (Object)"org.junit.Before", (Object)"org.junit.After", (Object)"org.junit.BeforeClass", (Object)"org.junit.AfterClass", (Object)"org.junit.jupiter.api.Test", (Object[])new String[]{"org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"});
    protected final Multimap<Class<?>, ElementType> targetInfos;
    private final ModifierValidator classModifierValidator;
    private final ModifierValidator interfaceModifierValidator;
    private final ModifierValidator enumModifierValidator;
    private final ModifierValidator annotationTypeModifierValidator;
    private final ModifierValidator nestedClassModifierValidator;
    private final ModifierValidator nestedInterfaceModifierValidator;
    private final ModifierValidator nestedEnumModifierValidator;
    private final ModifierValidator nestedAnnotationTypeModifierValidator;
    private final ModifierValidator fieldModifierValidator;
    private final ModifierValidator fieldInInterfaceModifierValidator;
    private final ModifierValidator constructorModifierValidator;
    private final ModifierValidator methodModifierValidator;
    private ModifierValidator methodInInterfaceModifierValidator;

    public XtendValidator() {
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        result.put(XtendClass.class, (Object)ElementType.TYPE);
        result.put(XtendInterface.class, (Object)ElementType.TYPE);
        result.put(XtendEnum.class, (Object)ElementType.TYPE);
        result.putAll(XtendAnnotationType.class, (Object[])new ElementType[]{ElementType.ANNOTATION_TYPE, ElementType.TYPE});
        result.put(XtendField.class, (Object)ElementType.FIELD);
        result.put(XtendFunction.class, (Object)ElementType.METHOD);
        result.put(XtendParameter.class, (Object)ElementType.PARAMETER);
        this.targetInfos = result.build();
        this.classModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "final", "abstract", "strictfp"}), this);
        this.interfaceModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "abstract", "strictfp"}), this);
        this.enumModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package"}), this);
        this.annotationTypeModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "abstract"}), this);
        this.nestedClassModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "protected", "private", "static", "final", "abstract", "strictfp"}), this);
        this.nestedInterfaceModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "protected", "private", "static", "abstract", "strictfp"}), this);
        this.nestedEnumModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "protected", "private", "static"}), this);
        this.nestedAnnotationTypeModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "package", "protected", "private", "static", "abstract"}), this);
        this.fieldModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "protected", "package", "private", "static", "final", "val", "var", "extension", "volatile", "transient"}), this);
        this.fieldInInterfaceModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "static", "final", "val"}), this);
        this.constructorModifierValidator = new ModifierValidator(Lists.newArrayList(this.visibilityModifers), this);
        this.methodModifierValidator = new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "protected", "package", "private", "static", "abstract", "dispatch", "final", "def", "override", "strictfp", "native", "synchronized"}), this);
    }

    protected List<EPackage> getEPackages() {
        ArrayList ePackages = Lists.newArrayList((Iterable)super.getEPackages());
        ePackages.add(XtendPackage.eINSTANCE);
        return ePackages;
    }

    protected GeneratorConfig getGeneratorConfig(EObject element) {
        GeneratorConfig result = (GeneratorConfig)this.getContext().get(GeneratorConfig.class);
        if (result == null) {
            result = this.generatorConfigProvider.get(element);
            this.getContext().put(GeneratorConfig.class, result);
        }
        if (this.methodInInterfaceModifierValidator == null) {
            this.methodInInterfaceModifierValidator = result.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8) ? new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "abstract", "static", "def", "override"}), this) : new ModifierValidator(Lists.newArrayList((Object[])new String[]{"public", "abstract", "def", "override"}), this);
        }
        return result;
    }

    protected boolean hasAnnotation(XtendAnnotationTarget source, Class<?> class1) {
        for (XAnnotation anno : source.getAnnotations()) {
            if (anno == null || anno.getAnnotationType() == null || !class1.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkValidExtension(XtendField field) {
        JvmField jvmField;
        if (field.isExtension() && (jvmField = this.associations.getJvmField(field)) != null) {
            this.checkValidExtensionType((JvmIdentifiableElement)jvmField, field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__TYPE);
        }
    }

    @Check
    public void checkNonRawTypeInferred(XtendField field) {
        JvmField jvmField;
        if (field.getType() == null && (jvmField = this.associations.getJvmField(field)) != null && jvmField.eResource() != null) {
            JvmTypeReference fieldType = jvmField.getType();
            this.validateInferredType(fieldType, field, "The inferred field type ", XtendPackage.Literals.XTEND_FIELD__NAME);
        }
    }

    @Check
    public void checkNonRawTypeInferred(XtendFunction function) {
        JvmOperation operation;
        if (function.getReturnType() == null && (operation = this.associations.getDirectlyInferredOperation(function)) != null && operation.eResource() != null) {
            JvmTypeReference returnType = operation.getReturnType();
            this.validateInferredType(returnType, function, "The inferred return type ", XtendPackage.Literals.XTEND_FUNCTION__NAME);
        }
    }

    @Check
    public void checkJUnitMethodReturnType(XtendFunction function) {
        LightweightTypeReference actualType;
        JvmOperation operation = this.associations.getDirectlyInferredOperation(function);
        if (this.hasJUnitAnnotation(operation) && (actualType = this.determineReturnType(operation)) != null && !actualType.isUnknown() && !actualType.isPrimitiveVoid()) {
            String message = String.format("JUnit method %s() must be void but is %s.", function.getName(), actualType.getHumanReadableName());
            EAttribute location = XtendPackage.Literals.XTEND_FUNCTION__NAME;
            this.error(message, function, (EStructuralFeature)location, "org.eclipse.xtend.core.validation.IssueCodes.invalid_return_type_in_case_of_junit_annotation", new String[0]);
        }
    }

    private LightweightTypeReference determineReturnType(JvmOperation operation) {
        if (operation != null && operation.eResource() != null) {
            return this.batchTypeResolver.resolveTypes((EObject)operation).getActualType((JvmIdentifiableElement)operation);
        }
        return null;
    }

    private boolean hasJUnitAnnotation(JvmOperation operation) {
        return !this.annotationUtil.findAnnotations(this.junitAnnotations, (JvmAnnotationTarget)operation).isEmpty();
    }

    protected void validateInferredType(JvmTypeReference inferredType, XtendMember member, String messagePrefix, EAttribute location) {
        if (inferredType != null) {
            TreeIterator iterator = EcoreUtil2.eAll((EObject)inferredType);
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                if (next instanceof JvmParameterizedTypeReference) {
                    JvmParameterizedTypeReference candidate = (JvmParameterizedTypeReference)next;
                    JvmType type = candidate.getType();
                    if (!(type instanceof JvmGenericType) || ((JvmGenericType)type).getTypeParameters().isEmpty() || !candidate.getArguments().isEmpty()) continue;
                    StringBuilder message = new StringBuilder(messagePrefix);
                    if ((message = this.proxyAwareUIStrings.visit(inferredType, message)) != null) {
                        message.append(" uses the raw type ");
                        message.append(type.getSimpleName());
                        message.append(". References to generic type ");
                        message = this.proxyAwareUIStrings.appendTypeSignature(type, message);
                        message.append(" should be parameterized");
                        this.warning(message.toString(), member, (EStructuralFeature)location, "org.eclipse.xtext.xbase.validation.IssueCodes.raw_type", new String[0]);
                    }
                    return;
                }
                if (!(next instanceof XComputedTypeReference)) continue;
                this.validateInferredType(((XComputedTypeReference)next).getEquivalent(), member, messagePrefix, location);
                iterator.prune();
            }
        }
    }

    @Check
    public void checkValidExtension(XtendFormalParameter parameter) {
        if (parameter.isExtension() && !(parameter.eContainer() instanceof XCatchClause)) {
            this.checkValidExtensionType((JvmIdentifiableElement)parameter, (EObject)parameter, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__PARAMETER_TYPE);
        }
    }

    @Check
    public void checkValidExtension(XtendVariableDeclaration variableDeclaration) {
        if (variableDeclaration.isExtension()) {
            this.checkValidExtensionType((JvmIdentifiableElement)variableDeclaration, (EObject)variableDeclaration, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME);
        }
    }

    @Check
    public void checkValidExtension(XtendParameter parameter) {
        JvmFormalParameter jvmParameter;
        if (parameter.isExtension() && (jvmParameter = this.associations.getJvmParameter(parameter)) != null) {
            this.checkValidExtensionType((JvmIdentifiableElement)jvmParameter, parameter, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__PARAMETER_TYPE);
        }
    }

    protected void checkValidExtensionType(JvmIdentifiableElement identifiable, EObject source, EStructuralFeature feature) {
        LightweightTypeReference type = this.getActualType(identifiable);
        if (type != null && type.isPrimitive()) {
            this.error(String.format("The primitive type %s is not a valid extension", type.getHumanReadableName()), source, feature, "org.eclipse.xtend.core.validation.IssueCodes.invalid_extension_type", new String[0]);
        }
    }

    @Check
    public void checkAnnotationTarget(XAnnotation annotation) {
        JvmType annotationType = annotation.getAnnotationType();
        if (annotationType == null || annotationType.eIsProxy() || !(annotationType instanceof JvmAnnotationType)) {
            return;
        }
        Set targets = this.annotationUtil.getAnnotationTargets((JvmAnnotationType)annotationType);
        if (targets.isEmpty()) {
            return;
        }
        EObject eContainer = this.getContainingAnnotationTarget(annotation);
        Class<Object> clazz = eContainer.getClass();
        if (eContainer instanceof XtendField && eContainer.eContainer() instanceof XtendAnnotationType) {
            clazz = XtendFunction.class;
        }
        for (Map.Entry mapping : this.targetInfos.asMap().entrySet()) {
            if (!((Class)mapping.getKey()).isAssignableFrom(clazz)) continue;
            targets.retainAll((Collection)mapping.getValue());
            if (!targets.isEmpty()) continue;
            this.error("The annotation @" + annotation.getAnnotationType().getSimpleName() + " is disallowed for this location.", (EObject)annotation, null, -1, "org.eclipse.xtend.core.validation.IssueCodes.wrong_annotation_target", new String[0]);
        }
    }

    @Check
    public void checkMultipleAnnotations(XtendAnnotationTarget annotationTarget) {
        if (annotationTarget.getAnnotations().size() <= 1 || !this.isRelevantAnnotationTarget(annotationTarget)) {
            return;
        }
        ImmutableListMultimap groupByIdentifier = Multimaps.index(annotationTarget.getAnnotations(), (Function)new Function<XAnnotation, String>(){

            public String apply(XAnnotation input) {
                return input.getAnnotationType().getIdentifier();
            }
        });
        for (String qName : groupByIdentifier.keySet()) {
            JvmType type;
            ImmutableList sameType = groupByIdentifier.get((Object)qName);
            if (sameType.size() <= 1 || !((type = ((XAnnotation)sameType.get(0)).getAnnotationType()) instanceof JvmAnnotationType) || type.eIsProxy() || this.annotationLookup.isRepeatable((JvmAnnotationType)type)) continue;
            for (XAnnotation xAnnotation : sameType) {
                this.error("Multiple annotations of non-repeatable type @" + xAnnotation.getAnnotationType().getSimpleName() + ". Only annotation types marked @Repeatable can be used multiple times at one target.", (EObject)xAnnotation, (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, -1, "org.eclipse.xtend.core.validation.IssueCodes.multiple_annotations_used", new String[0]);
            }
        }
    }

    protected boolean isRelevantAnnotationTarget(final XtendAnnotationTarget annotationTarget) {
        return Iterables.any((Iterable)this.targetInfos.keySet(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isInstance(annotationTarget);
            }
        });
    }

    protected EObject getContainingAnnotationTarget(XAnnotation annotation) {
        EObject eContainer = annotation.eContainer();
        if (eContainer.eClass() == XtendPackage.Literals.XTEND_MEMBER || eContainer.eClass() == XtendPackage.Literals.XTEND_TYPE_DECLARATION) {
            return eContainer.eContainer();
        }
        return eContainer;
    }

    @Check
    public void checkNoTypeNameShadowing(XtendTypeDeclaration type) {
        String name = type.getName();
        if (name != null && name.length() > 0) {
            XtendTypeDeclaration outer = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)type.eContainer(), XtendTypeDeclaration.class);
            while (outer != null) {
                if (name.equals(outer.getName())) {
                    this.acceptError("The nested type " + name + " cannot hide an enclosing type", type, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name", new String[0]);
                    return;
                }
                outer = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)outer.eContainer(), XtendTypeDeclaration.class);
            }
        }
    }

    @Check
    public void checkVarArgIsNotExtension(XtendParameter param) {
        if (param.isVarArg() && param.isExtension()) {
            this.error("A vararg may not be an extension.", param, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__EXTENSION, "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_varArg", new String[0]);
        }
    }

    @Check
    public void checkVarArgComesLast(XtendParameter param) {
        List params;
        if (param.isVarArg() && param != Iterables.getLast((Iterable)(params = (List)param.eContainer().eGet(param.eContainingFeature())))) {
            this.error("A vararg must be the last parameter.", param, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__VAR_ARG, "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_varArg", new String[0]);
        }
    }

    @Check
    public void checkClassPath(XtendFile xtendFile) {
        TypeReferences typeReferences = this.getServices().getTypeReferences();
        JvmGenericType listType = (JvmGenericType)typeReferences.findDeclaredType(List.class, (Notifier)xtendFile);
        if (listType == null || listType.getTypeParameters().isEmpty()) {
            this.error("Couldn't find a JDK 1.5 or higher on the project's classpath.", xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, "org.eclipse.xtend.core.validation.IssueCodes.jdk_not_on_classpath", new String[0]);
        } else if (typeReferences.findDeclaredType(ToStringBuilder.class, (Notifier)xtendFile) == null) {
            this.error("Couldn't find the mandatory library 'org.eclipse.xtext.xbase.lib' 2.8.0 or higher on the project's classpath.", xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, "org.eclipse.xtend.core.validation.IssueCodes.xbase_lib_not_on_classpath", new String[0]);
        }
    }

    @Check
    public void checkWhitespaceInRichStrings(RichString richString) {
        Object container;
        if (richString.eContainer() instanceof RichStringIf && ((container = (RichStringIf)richString.eContainer()).getThen() == richString || container.getElse() == richString)) {
            return;
        }
        if (richString.eContainer() instanceof RichStringElseIf && (container = (RichStringElseIf)richString.eContainer()).getThen() == richString) {
            return;
        }
        if (richString.eContainer() instanceof RichStringForLoop && (container = (RichStringForLoop)richString.eContainer()).getEachExpression() == richString) {
            return;
        }
        this.doCheckWhitespaceIn(richString);
    }

    protected void doCheckWhitespaceIn(RichString richString) {
        ValidatingRichStringAcceptor helper = new ValidatingRichStringAcceptor((ValidationMessageAcceptor)this);
        this.richStringProcessor.process(richString, helper, helper);
    }

    protected EObject findPrimarySourceElement(IResolvedOperation operation) {
        return this.associations.getPrimarySourceElement((EObject)operation.getDeclaration());
    }

    protected boolean isMorePrivateThan(JvmVisibility o1, JvmVisibility o2) {
        if (o1 == o2) {
            return false;
        }
        switch (o1) {
            case DEFAULT: {
                return o2 != JvmVisibility.PRIVATE;
            }
            case PRIVATE: {
                return true;
            }
            case PROTECTED: {
                return o2 == JvmVisibility.PUBLIC;
            }
            case PUBLIC: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown JvmVisibility " + String.valueOf(o1));
    }

    @Check
    public void checkParameterNames(XtendFunction function) {
        int i = 0;
        while (i < function.getParameters().size()) {
            String leftParameterName = ((XtendParameter)function.getParameters().get(i)).getName();
            if (function.getCreateExtensionInfo() != null && Strings.equal((String)leftParameterName, (String)function.getCreateExtensionInfo().getName())) {
                this.error("Duplicate parameter " + leftParameterName, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                if (function.getCreateExtensionInfo().eIsSet((EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME)) {
                    this.error("Duplicate parameter " + leftParameterName, function.getCreateExtensionInfo(), (EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                } else {
                    this.error("Duplicate implicit parameter 'it'", function.getCreateExtensionInfo(), (EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                }
            }
            ++i;
        }
    }

    @Check
    public void checkAbstract(XtendFunction function) {
        XtendTypeDeclaration declarator = function.getDeclaringType();
        if (function.getExpression() == null) {
            if (declarator instanceof XtendClass || declarator.isAnonymous()) {
                if (function.isDispatch()) {
                    this.error("The dispatch method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " must not be abstract", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "dispatch_functions_must_not_be_abstract", new String[0]);
                    return;
                }
                if (function.getCreateExtensionInfo() != null) {
                    this.error("The 'create'-method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " must not be abstract", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "create_functions_must_not_be_abstract", new String[0]);
                    return;
                }
                if (declarator.isAnonymous()) {
                    this.error("The abstract method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " can only be defined by an abstract class.", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract_in_anonymous", new String[0]);
                } else if (!((XtendClass)declarator).isAbstract() && !function.isNative()) {
                    this.error("The abstract method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " can only be defined by an abstract class.", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract", new String[0]);
                }
                if (function.getReturnType() == null && !function.isOverride()) {
                    this.error("The " + (function.isNative() ? "native" : "abstract") + " method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " must declare a return type", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.abstract_method_missing_return_type", new String[0]);
                }
            } else if (declarator instanceof XtendInterface) {
                if (function.getCreateExtensionInfo() != null) {
                    this.error("'Create'-method " + function.getName() + " is not permitted in an interface", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "create_functions_must_not_be_abstract", new String[0]);
                    return;
                }
                if (function.getReturnType() == null && !function.isOverride()) {
                    this.error("The abstract method " + function.getName() + " in type " + this.localClassAwareTypeNames.getReadableName(declarator) + " must declare a return type", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.abstract_method_missing_return_type", new String[0]);
                }
            }
        } else if (declarator instanceof XtendInterface && !this.getGeneratorConfig(function).getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8)) {
            this.error("Abstract methods do not specify a body", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.abstract_method_with_body", new String[0]);
        }
    }

    @Check
    public void checkOperatorSignature(XtendFunction function) {
        JvmOperation operation;
        QualifiedName qualifiedName;
        QualifiedName operator;
        String functionName = function.getName();
        if (functionName != null && (operator = this.operatorMapping.getOperator(qualifiedName = QualifiedName.create((String)functionName))) != null && (operation = this.associations.getDirectlyInferredOperation(function)) != null) {
            int parameterSize = operation.getParameters().size();
            if (function.isStatic()) {
                if (this.operatorMapping.isUnaryOperator(operator) && this.operatorMapping.isBinaryOperator(operator)) {
                    if (parameterSize < 1) {
                        this.addIssue("The static operator '" + String.valueOf(operator) + "' requires at least one argument.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    } else if (parameterSize > 2) {
                        this.addIssue("The static operator '" + String.valueOf(operator) + "' allows at most two arguments.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    }
                } else if (this.operatorMapping.isUnaryOperator(operator)) {
                    if (parameterSize != 1) {
                        this.addIssue("The static unary operator '" + String.valueOf(operator) + "' requires exactly one argument.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    }
                } else if (parameterSize != 2) {
                    this.addIssue("The static binary operator '" + String.valueOf(operator) + "' requires exactly two arguments.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (this.operatorMapping.isUnaryOperator(operator) && this.operatorMapping.isBinaryOperator(operator)) {
                if (parameterSize > 2) {
                    this.addIssue("The operator '" + String.valueOf(operator) + "' allows at most two arguments.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (this.operatorMapping.isUnaryOperator(operator)) {
                if (parameterSize > 1) {
                    this.addIssue("The unary operator '" + String.valueOf(operator) + "' allows at most one argument.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (parameterSize == 0) {
                this.addIssue("The binary operator '" + String.valueOf(operator) + "' requires at least one argument.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
            } else if (parameterSize > 2) {
                this.addIssue("The binary operator '" + String.valueOf(operator) + "' allows at most two arguments.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
            }
        }
    }

    @Check
    public void dispatchFuncWithTypeParams(XtendFunction func) {
        if (func.isDispatch()) {
            if (func.getParameters().isEmpty()) {
                this.error("A dispatch method must at least have one parameter declared.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, func.getModifiers().indexOf((Object)"dispatch"), "org.eclipse.xtend.core.validation.IssueCodes.case_function_without_params", new String[0]);
            }
            if (!func.getTypeParameters().isEmpty()) {
                this.error("A dispatch method must not declare any type parameters.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, func.getModifiers().indexOf((Object)"dispatch"), "org.eclipse.xtend.core.validation.IssueCodes.case_function_with_type_params", new String[0]);
            }
            if (func.getName().startsWith("_")) {
                this.error("A dispatch method's name must not start with an underscore.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.case_func_name_starts_with_underscore", new String[0]);
            }
        }
    }

    @Check
    public void checkDispatchFunctions(XtendClass clazz) {
        JvmGenericType type = this.associations.getInferredType(clazz);
        if (type != null) {
            ListMultimap<DispatchHelper.DispatchSignature, JvmOperation> dispatchMethods = this.dispatchHelper.getDeclaredOrEnhancedDispatchMethods((JvmDeclaredType)type);
            this.checkDispatchNonDispatchConflict(clazz, (Multimap<DispatchHelper.DispatchSignature, JvmOperation>)dispatchMethods);
            for (DispatchHelper.DispatchSignature signature : dispatchMethods.keySet()) {
                Collection dispatchOperations = dispatchMethods.get((Object)signature);
                JvmOperation syntheticDispatchMethod = this.dispatchHelper.getDispatcherOperation((JvmDeclaredType)type, signature);
                if (syntheticDispatchMethod == null) continue;
                JvmOperation overriddenOperation = this.overrideHelper.findOverriddenOperation(syntheticDispatchMethod);
                Boolean expectStatic = null;
                if (overriddenOperation != null) {
                    if (this.isMorePrivateThan(syntheticDispatchMethod.getVisibility(), overriddenOperation.getVisibility())) {
                        String msg = "Synthetic dispatch method reduces visibility of overridden method " + overriddenOperation.getIdentifier();
                        this.addDispatchError(type, dispatchOperations, msg, null, "org.eclipse.xtext.xbase.validation.IssueCodes.override_reduces_visibility");
                    }
                    expectStatic = overriddenOperation.isStatic();
                }
                LightweightTypeReference dispatchMethodReturnType = this.getActualType(clazz, (JvmIdentifiableElement)syntheticDispatchMethod);
                if (dispatchOperations.size() == 1) {
                    JvmOperation singleOp = (JvmOperation)dispatchOperations.iterator().next();
                    XtendFunction function = this.associations.getXtendFunction(singleOp);
                    this.addIssue("Single dispatch method.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)"dispatch"), "org.eclipse.xtend.core.validation.IssueCodes.single_case_function", new String[0]);
                    continue;
                }
                HashMultimap signatures = HashMultimap.create();
                boolean[] allPrimitive = new boolean[signature.getArity()];
                Arrays.fill(allPrimitive, true);
                boolean isFirstLocalOperation = true;
                JvmVisibility commonVisibility = null;
                Boolean commonStatic = null;
                for (JvmOperation jvmOperation : dispatchOperations) {
                    LightweightTypeReference operationType;
                    XtendFunction function;
                    signatures.put(this.getParamTypes(jvmOperation, true), (Object)jvmOperation);
                    int i = 0;
                    while (i < jvmOperation.getParameters().size()) {
                        JvmFormalParameter parameter = (JvmFormalParameter)jvmOperation.getParameters().get(i);
                        if (!(parameter.getParameterType().getType() instanceof JvmPrimitiveType)) {
                            allPrimitive[i] = false;
                        }
                        ++i;
                    }
                    if (jvmOperation.getDeclaringType() != type) continue;
                    if (expectStatic != null) {
                        if (expectStatic.booleanValue() && !jvmOperation.isStatic()) {
                            String msg = "The dispatch method must be static because the dispatch methods in the superclass are static.";
                            this.addDispatchError(jvmOperation, msg, "static", "dispatch_functions_static_expected");
                        }
                        if (!expectStatic.booleanValue() && jvmOperation.isStatic()) {
                            String msg = "The dispatch method must not be static because the dispatch methods in the superclass are not static.";
                            this.addDispatchError(jvmOperation, msg, "static", "dispatch_functions_non_static_expected");
                        }
                    }
                    if (isFirstLocalOperation) {
                        commonVisibility = jvmOperation.getVisibility();
                        commonStatic = jvmOperation.isStatic();
                        isFirstLocalOperation = false;
                    } else {
                        if (jvmOperation.getVisibility() != commonVisibility) {
                            commonVisibility = null;
                        }
                        if (commonStatic != null && commonStatic.booleanValue() != jvmOperation.isStatic()) {
                            commonStatic = null;
                        }
                    }
                    if (dispatchMethodReturnType == null || (function = this.associations.getXtendFunction(jvmOperation)) == null || dispatchMethodReturnType.isAssignableFrom(operationType = this.getActualType((EObject)function.getExpression(), (JvmIdentifiableElement)jvmOperation))) continue;
                    this.error("Incompatible return type of dispatch method. Expected " + dispatchMethodReturnType.getHumanReadableName() + " but was " + operationType.getHumanReadableName(), function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__RETURN_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
                }
                if (commonVisibility == null) {
                    this.addDispatchError(type, dispatchOperations, "All local dispatch methods must have the same visibility.", null, "dispatch_functions_with_different_visibility");
                }
                if (expectStatic == null && commonStatic == null) {
                    this.addDispatchError(type, dispatchOperations, "Static and non-static dispatch methods can not be mixed.", "static", "dispatch_functions_mixed_static_and_non_static");
                }
                for (final List paramTypes : signatures.keySet()) {
                    Collection ops = signatures.get((Object)paramTypes);
                    if (ops.size() <= 1 || !Iterables.any((Iterable)ops, (Predicate)new Predicate<JvmOperation>(){

                        public boolean apply(JvmOperation input) {
                            return !XtendValidator.this.getParamTypes(input, false).equals(paramTypes);
                        }
                    })) continue;
                    for (JvmOperation jvmOperation : ops) {
                        XtendFunction function = this.associations.getXtendFunction(jvmOperation);
                        this.error("Duplicate dispatch methods. Primitives cannot overload their wrapper types in dispatch methods.", function, null, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method", new String[0]);
                    }
                }
                int i = 0;
                while (i < allPrimitive.length) {
                    if (allPrimitive[i]) {
                        Iterator operationIter = dispatchOperations.iterator();
                        JvmType paramType1 = ((JvmFormalParameter)((JvmOperation)operationIter.next()).getParameters().get(i)).getParameterType().getType();
                        while (operationIter.hasNext()) {
                            JvmType paramType2 = ((JvmFormalParameter)((JvmOperation)operationIter.next()).getParameters().get(i)).getParameterType().getType();
                            if (paramType2.equals(paramType1)) continue;
                            for (JvmOperation jvmOperation : dispatchOperations) {
                                XtendFunction function = this.associations.getXtendFunction(jvmOperation);
                                this.addIssue("Dispatch methods have arguments with different primitive types.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_functions_different_primitive_args", new String[0]);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void checkDispatchNonDispatchConflict(XtendClass clazz, Multimap<DispatchHelper.DispatchSignature, JvmOperation> dispatchMethods) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash")) {
            return;
        }
        HashMultimap nonDispatchMethods = HashMultimap.create();
        for (XtendFunction method : Iterables.filter(clazz.getMembers(), XtendFunction.class)) {
            if (method.isDispatch()) continue;
            nonDispatchMethods.put((Object)new DispatchHelper.DispatchSignature(method.getName(), method.getParameters().size()), (Object)method);
        }
        for (DispatchHelper.DispatchSignature dispatchSignature : dispatchMethods.keySet()) {
            if (!nonDispatchMethods.containsKey((Object)dispatchSignature)) continue;
            for (XtendFunction function : nonDispatchMethods.get((Object)dispatchSignature)) {
                this.addIssue("Non-dispatch method has same name and number of parameters as dispatch method", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash", new String[0]);
            }
            for (JvmOperation operation : dispatchMethods.get((Object)dispatchSignature)) {
                XtendFunction function = this.associations.getXtendFunction(operation);
                if (function.eResource() != clazz.eResource()) continue;
                this.addIssue("Dispatch method has same name and number of parameters as non-dispatch method", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash", new String[0]);
            }
        }
    }

    protected void addDispatchError(JvmGenericType type, Iterable<JvmOperation> operations, String message, String modifier, String ISSUE_ID) {
        for (JvmOperation jvmOperation : operations) {
            if (jvmOperation.getDeclaringType() != type) continue;
            this.addDispatchError(jvmOperation, message, modifier, ISSUE_ID);
        }
    }

    protected void addDispatchError(JvmOperation jvmOperation, String message, String modifier, String ISSUE_ID) {
        XtendFunction function = this.associations.getXtendFunction(jvmOperation);
        if (function != null) {
            int modifierIndex = -1;
            if (modifier != null) {
                modifierIndex = function.getModifiers().indexOf((Object)modifier);
            } else {
                int i = 0;
                while (i < function.getModifiers().size()) {
                    if (this.visibilityModifers.contains(function.getModifiers().get(i))) {
                        modifierIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            if (modifierIndex == -1) {
                modifierIndex = function.getModifiers().indexOf((Object)"dispatch");
            }
            this.error(message, function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, modifierIndex, ISSUE_ID, new String[0]);
        }
    }

    protected List<JvmType> getParamTypes(JvmOperation jvmOperation, boolean wrapPrimitives) {
        ArrayList types = Lists.newArrayList();
        for (JvmFormalParameter p : jvmOperation.getParameters()) {
            LightweightTypeReference typeReference = this.toLightweightTypeReference(p.getParameterType());
            if (wrapPrimitives) {
                typeReference = typeReference.getWrapperTypeIfPrimitive();
            }
            types.add(typeReference.getType());
        }
        return types;
    }

    @Check
    public void checkNoReturnsInCreateExtensions(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        ArrayList found = Lists.newArrayList();
        this.collectReturnExpressions((EObject)func.getCreateExtensionInfo().getCreateExpression(), found);
        for (XReturnExpression xReturnExpression : found) {
            this.error("Return is not allowed in creation expression", (EObject)xReturnExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
        }
    }

    @Check
    public void checkCreateFunctionIsNotTypeVoid(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        if (func.getReturnType() == null) {
            JvmOperation operation = this.associations.getDirectlyInferredOperation(func);
            if (operation != null && this.isPrimitiveVoid(operation.getReturnType())) {
                this.error("void is an invalid type for the create method " + func.getName(), func, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        } else if (this.isPrimitiveVoid(func.getReturnType())) {
            if (func.getReturnType() != null) {
                this.error("Create method " + func.getName() + " may not declare return type void.", (EObject)func.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            } else {
                this.error("The inherited return type void of " + func.getName() + " is invalid for create method.", (EObject)func.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        }
    }

    @Check
    public void checkCreateFunctionIsNotGeneric(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        if (!func.getTypeParameters().isEmpty()) {
            this.error("Create methods can not have type parameters.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, func.getModifiers().indexOf((Object)"static"), "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_static", new String[0]);
        }
    }

    @Check
    public void checkCreateFunctionIsNotStatic(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        if (func.isStatic()) {
            this.error("Create methods can not be static.", func, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, func.getModifiers().indexOf((Object)"static"), "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_static", new String[0]);
        }
    }

    protected boolean isValueExpectedRecursive(XExpression expr) {
        EObject container = expr.eContainer();
        if (container instanceof RichString || container instanceof RichStringForLoop || container instanceof XtendField) {
            return true;
        }
        return super.isValueExpectedRecursive(expr);
    }

    protected void collectReturnExpressions(EObject expr, List<XReturnExpression> found) {
        if (expr instanceof XReturnExpression) {
            found.add((XReturnExpression)expr);
        } else if (expr instanceof XClosure) {
            return;
        }
        for (EObject child : expr.eContents()) {
            this.collectReturnExpressions(child, found);
        }
    }

    public boolean doCheckValidMemberName(XtendMember member) {
        String name;
        EStructuralFeature nameAttribute = member.eClass().getEStructuralFeature("name");
        if (nameAttribute != null && (name = (String)member.eGet(nameAttribute)) != null && (name.equals("this") || name.equals("it"))) {
            this.error("'it' and 'this' are not allowed as member names", nameAttribute, "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name", new String[0]);
            return false;
        }
        return true;
    }

    @Check
    public void checkLocalUsageOfDeclaredFields(XtendField field) {
        if (this.doCheckValidMemberName(field) && !this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member")) {
            JvmField jvmField = this.associations.getJvmField(field);
            if (jvmField == null || jvmField.getVisibility() != JvmVisibility.PRIVATE || jvmField.eContainer() == null) {
                return;
            }
            if (this.isLocallyUsed((EObject)jvmField, this.getOutermostType(field))) {
                return;
            }
            String message = field.isExtension() ? (field.getName() == null && jvmField.getType() != null ? "The extension " + jvmField.getType().getIdentifier() + " is not used in " + this.getDeclaratorName((JvmFeature)jvmField) : "The extension " + this.getDeclaratorName((JvmFeature)jvmField) + "." + jvmField.getSimpleName() + " is not used") : "The value of the field " + this.getDeclaratorName((JvmFeature)jvmField) + "." + jvmField.getSimpleName() + " is not used";
            this.addIssueToState("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member", message, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final EObject getOutermostType(XtendMember member) {
        result = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)member, XtendTypeDeclaration.class);
        if (result != null) ** GOTO lbl8
        return member.eContainer();
lbl-1000:
        // 1 sources

        {
            next = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)result.eContainer(), XtendTypeDeclaration.class);
            if (next == null) {
                return result;
            }
            result = next;
lbl8:
            // 2 sources

            ** while (!(result.eContainer() instanceof XtendFile))
        }
lbl9:
        // 1 sources

        return result;
    }

    protected String getDeclaratorName(JvmFeature feature) {
        JvmDeclaredType declarator = feature.getDeclaringType();
        if (declarator.isLocal()) {
            return "new " + ((JvmTypeReference)Iterables.getLast((Iterable)declarator.getSuperTypes())).getType().getSimpleName() + "(){}";
        }
        return declarator.getSimpleName();
    }

    @Check
    public void checkLocalUsageOfDeclaredXtendFunction(XtendFunction function) {
        if (this.doCheckValidMemberName(function) && !this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member")) {
            JvmOperation jvmOperation;
            JvmOperation jvmOperation2 = jvmOperation = function.isDispatch() ? this.associations.getDispatchOperation(function) : this.associations.getDirectlyInferredOperation(function);
            if (jvmOperation != null && jvmOperation.getVisibility() == JvmVisibility.PRIVATE && !this.isLocallyUsed((EObject)jvmOperation, this.getOutermostType(function))) {
                String message = "The method " + jvmOperation.getSimpleName() + this.uiStrings.parameters((JvmIdentifiableElement)jvmOperation) + " from the type " + this.getDeclaratorName((JvmFeature)jvmOperation) + " is never used locally.";
                this.addIssueToState("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member", message, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME);
            }
        }
    }

    @Check
    public void checkTypeParameterForwardReferences(XtendClass xtendClass) {
        this.doCheckTypeParameterForwardReference((List)xtendClass.getTypeParameters());
    }

    @Check
    public void checkTypeParameterForwardReferences(XtendInterface xtendInterface) {
        this.doCheckTypeParameterForwardReference((List)xtendInterface.getTypeParameters());
    }

    @Check
    public void checkTypeParameterForwardReferences(XtendFunction xtendFunction) {
        this.doCheckTypeParameterForwardReference((List)xtendFunction.getTypeParameters());
    }

    @Check
    public void checkTypeParametersAreUnsupported(XtendConstructor constructor) {
        if (!constructor.getTypeParameters().isEmpty()) {
            this.error("Type parameters are not supported for constructors", (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__TYPE_PARAMETERS, -1, "org.eclipse.xtend.core.validation.IssueCodes.constructor_type_params_not_supported", new String[0]);
        }
    }

    @Check
    public void checkLeftHandSideIsVariable(XAssignment assignment) {
        String concreteSyntaxFeatureName = assignment.getConcreteSyntaxFeatureName();
        if (concreteSyntaxFeatureName.equals(IFeatureNames.THIS.toString())) {
            this.error("Left-hand side of an assignment must be an variable", (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, "left_hand_side_must_be_variable", new String[0]);
        }
    }

    @Check
    public void checkJavaKeywordConflict(XtendField member) {
        this.checkNoJavaKeyword(member, XtendPackage.Literals.XTEND_FIELD__NAME);
    }

    @Check
    public void checkJavaKeywordConflict(XtendFunction member) {
        if (member.eContainer() instanceof XtendAnnotationType && "do".equals(member.getName())) {
            return;
        }
        this.checkNoJavaKeyword(member, XtendPackage.Literals.XTEND_FUNCTION__NAME);
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check
    public void checkJavaKeywordConflict(XtendConstructor member) {
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check
    public void checkJavaKeywordConflict(XtendTypeDeclaration member) {
        this.checkNoJavaKeyword(member, XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME);
    }

    @Check
    public void checkJavaKeywordConflict(XtendClass member) {
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check
    public void checkJavaKeywordConflict(XtendInterface member) {
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    protected void checkNoJavaKeyword(EObject obj, EAttribute attribute) {
        Object name = obj.eGet((EStructuralFeature)attribute);
        if (name != null && this.javaUtils.isJavaKeyword(name.toString())) {
            this.error("'" + String.valueOf(name) + "' is not a valid identifier.", obj, (EStructuralFeature)attribute, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_identifier", new String[0]);
        }
    }

    @Check
    public void checkNonInitializedFieldsHaveAType(XtendField field) {
        if (field.getType() == null && field.getInitialValue() == null) {
            this.error("The field " + field.getName() + " needs an explicit type since there is no initialization expression to infer the type from.", field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
        }
    }

    @Check
    public void checkFieldsAreCalledSelf(XtendField field) {
        if ("self".equals(field.getName())) {
            this.addIssue("'self' is a discouraged name", field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged", new String[0]);
        }
    }

    @Check
    public void checkFinalFieldInitialization(XtendClass clazz) {
        JvmGenericType inferredType = this.associations.getInferredType(clazz);
        if (inferredType == null) {
            return;
        }
        super.checkFinalFieldInitialization(inferredType);
    }

    @Check
    public void checkFinalFieldInitialization(XtendInterface xtendInterface) {
        JvmGenericType inferredType = this.associations.getInferredType(xtendInterface);
        if (inferredType == null) {
            return;
        }
        super.checkFinalFieldInitialization(inferredType);
    }

    @Check
    public void checkJavaDocRefs(XtendMember member) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking")) {
            return;
        }
        List documentationNodes = ((IEObjectDocumentationProviderExtension)this.documentationProvider).getDocumentationNodes((EObject)member);
        for (INode node : documentationNodes) {
            for (ReplaceRegion region : this.javaDocTypeReferenceProvider.computeTypeRefRegions(node)) {
                Severity severity;
                IScope scope;
                IEObjectDescription candidate;
                String typeRefString = region.getText();
                if (typeRefString == null || typeRefString.length() <= 0 || (candidate = (scope = this.scopeProvider.getScope((EObject)member, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)).getSingleElement(this.qualifiedNameConverter.toQualifiedName(typeRefString))) != null || (severity = this.getIssueSeverities(this.getContext(), this.getCurrentObject()).getSeverity("org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking")) == null) continue;
                this.getChain().add(this.createDiagnostic(severity, "javaDoc: " + typeRefString + " cannot be resolved to a type", member, region.getOffset(), region.getLength(), "org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking", new String[0]));
            }
        }
    }

    protected void reportUninitializedField(JvmField field) {
        EObject element = this.associations.getPrimarySourceElement((EObject)field);
        if (element instanceof XtendField) {
            this.error("The blank final field " + field.getSimpleName() + " may not have been initialized.", element, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
        } else {
            this.error("The blank final derived field " + field.getSimpleName() + " may not have been initialized.", element, null, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
        }
    }

    protected void reportUninitializedField(JvmField field, JvmConstructor constructor) {
        EObject sourceElement = this.associations.getPrimarySourceElement((EObject)constructor);
        if (sourceElement != null) {
            if (this.associations.getXtendField(field) != null) {
                this.error("The blank final field " + field.getSimpleName() + " may not have been initialized.", sourceElement, null, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
            } else {
                this.error("The blank final derived field " + field.getSimpleName() + " may not have been initialized.", sourceElement, null, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
            }
        }
    }

    protected boolean hasAnnotation(Iterable<? extends XAnnotation> annotations, Class<?> annotationType) {
        for (XAnnotation xAnnotation : annotations) {
            if (xAnnotation.getAnnotationType() == null || !annotationType.getName().equals(xAnnotation.getAnnotationType().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    @Check
    protected void checkModifiers(XtendClass xtendClass) {
        EObject eContainer = xtendClass.eContainer();
        if (eContainer instanceof XtendFile) {
            this.classModifierValidator.checkModifiers(xtendClass, "class " + xtendClass.getName());
        } else {
            this.nestedClassModifierValidator.checkModifiers(xtendClass, "class " + xtendClass.getName());
            if (!xtendClass.isStatic() && eContainer instanceof XtendClass) {
                this.error("Nested classes must be static", (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_static_modifier", new String[0]);
            }
        }
    }

    @Check
    protected void checkModifiers(XtendInterface xtendInterface) {
        EObject eContainer = xtendInterface.eContainer();
        if (eContainer instanceof XtendFile) {
            this.interfaceModifierValidator.checkModifiers(xtendInterface, "interface " + xtendInterface.getName());
        } else {
            this.nestedInterfaceModifierValidator.checkModifiers(xtendInterface, "interface " + xtendInterface.getName());
        }
    }

    @Check
    protected void checkModifiers(XtendEnum xtendEnum) {
        EObject eContainer = xtendEnum.eContainer();
        if (eContainer instanceof XtendFile) {
            this.enumModifierValidator.checkModifiers(xtendEnum, "enum " + xtendEnum.getName());
        } else {
            this.nestedEnumModifierValidator.checkModifiers(xtendEnum, "enum " + xtendEnum.getName());
        }
    }

    @Check
    protected void checkModifiers(XtendAnnotationType annotation) {
        EObject eContainer = annotation.eContainer();
        if (eContainer instanceof XtendFile) {
            this.annotationTypeModifierValidator.checkModifiers(annotation, "annotation type " + annotation.getName());
        } else {
            this.nestedAnnotationTypeModifierValidator.checkModifiers(annotation, "annotation type " + annotation.getName());
        }
    }

    @Check
    protected void checkModifiers(XtendField field) {
        XtendTypeDeclaration declaringType = field.getDeclaringType();
        if (declaringType instanceof XtendClass || declaringType instanceof AnonymousClass) {
            if (field.isFinal() && field.isVolatile()) {
                this.error("The field " + field.getName() + " can be either final or volatile, not both.", (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
            }
            this.fieldModifierValidator.checkModifiers(field, this.getMemberName(field));
        } else if (declaringType instanceof XtendInterface || declaringType instanceof XtendAnnotationType) {
            this.fieldInInterfaceModifierValidator.checkModifiers(field, "field " + field.getName());
        }
    }

    protected String getMemberName(XtendField field) {
        LightweightTypeReference type;
        JvmField jvmField;
        String memberName = "field " + field.getName();
        if (field.isExtension() && field.getName() == null && (jvmField = this.associations.getJvmField(field)) != null && (type = this.getActualType((JvmIdentifiableElement)jvmField)) != null) {
            memberName = "extension field " + type.getHumanReadableName();
        }
        return memberName;
    }

    @Check
    protected void checkModifiers(XtendConstructor constructor) {
        if (!(constructor.getDeclaringType() instanceof XtendClass)) {
            this.error("Contructors are only permitted within classes", null, "org.eclipse.xtend.core.validation.IssueCodes.constructor_not_permitted", new String[0]);
        } else {
            String typeName = ((XtendTypeDeclaration)constructor.eContainer()).getName();
            this.constructorModifierValidator.checkModifiers(constructor, "type " + typeName);
        }
    }

    @Check
    protected void checkModifiers(XtendFunction method) {
        XtendTypeDeclaration declaringType = method.getDeclaringType();
        if (declaringType instanceof XtendClass || declaringType instanceof AnonymousClass) {
            this.methodModifierValidator.checkModifiers(method, "method " + method.getName());
            int abstractIndex = method.getModifiers().indexOf((Object)"abstract");
            int nativeIndex = method.getModifiers().indexOf((Object)"native");
            if (method.getExpression() != null) {
                if (abstractIndex != -1) {
                    this.error("Method " + method.getName() + " with a body cannot be abstract", (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, abstractIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                } else if (method.isNative()) {
                    this.error("Native methods do not specify a body", (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                }
            } else if (nativeIndex == -1) {
                int staticIndex;
                int privateIndex;
                int finalIndex = method.getModifiers().indexOf((Object)"final");
                if (finalIndex != -1) {
                    this.error("Abstract method " + method.getName() + " cannot be final", (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, finalIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                }
                if ((privateIndex = method.getModifiers().indexOf((Object)"private")) != -1) {
                    this.error("Abstract method " + method.getName() + " cannot be private", (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, privateIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                }
                if ((staticIndex = method.getModifiers().indexOf((Object)"static")) != -1) {
                    this.error("Abstract method " + method.getName() + " cannot be static", (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, staticIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                }
            }
        } else if (declaringType instanceof XtendInterface) {
            GeneratorConfig config = this.getGeneratorConfig(method);
            this.methodInInterfaceModifierValidator.checkModifiers(method, "method " + method.getName());
            int abstractIndex = method.getModifiers().indexOf((Object)"abstract");
            if (config.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8) && method.getExpression() != null && abstractIndex != -1) {
                this.error("Method " + method.getName() + " with a body cannot be abstract", (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, abstractIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
            }
        }
    }

    @Check
    protected void checkInferedApi(XtendFunction method) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.api_type_inference")) {
            return;
        }
        if (this.isApi(method) && method.getReturnType() == null && !method.isOverride()) {
            this.addIssue("API method needs explicit return type", method, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.api_type_inference", new String[0]);
        }
    }

    @Check
    protected void checkInferedApi(XtendField field) {
        if (this.isApi(field) && field.getType() == null && field.getInitialValue() != null) {
            this.addIssue("API field needs explicit type", field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtend.core.validation.IssueCodes.api_type_inference", new String[0]);
        }
    }

    protected boolean isApi(XtendMember member) {
        if (!this.isApi(member.getDeclaringType())) {
            return false;
        }
        return member.getVisibility() == JvmVisibility.PUBLIC || member.getVisibility() == JvmVisibility.PROTECTED && !member.getDeclaringType().isFinal();
    }

    protected boolean isApi(XtendTypeDeclaration type) {
        boolean api;
        if (type.isAnonymous()) {
            return false;
        }
        boolean bl = api = type.getVisibility() == JvmVisibility.PUBLIC;
        if (type.getDeclaringType() != null) {
            api = api || type.getVisibility() == JvmVisibility.PROTECTED && !type.getDeclaringType().isFinal();
            api = api && this.isApi(type.getDeclaringType());
        }
        return api;
    }

    @Check
    protected void checkModifierMatchesTypename(XtendClass xtendClass) {
        String name = xtendClass.getName();
        if (name != null && name.startsWith("Abstract") && !xtendClass.isAbstract()) {
            this.addIssue("The class \"" + name + "\" is not declared abstract.", xtendClass, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract_modifier", new String[0]);
        }
    }

    @Check
    protected void checkImplicitReturn(final XtendFunction method) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.implicit_return")) {
            return;
        }
        JvmOperation jvmOperation = this.associations.getDirectlyInferredOperation(method);
        IResolvedTypes types = this.batchTypeResolver.resolveTypes((EObject)method);
        if (jvmOperation != null && types.getActualType((JvmIdentifiableElement)jvmOperation).isPrimitiveVoid()) {
            return;
        }
        this.implicitReturnFinder.findImplicitReturns(method.getExpression(), new ImplicitReturnFinder.Acceptor(){

            public void accept(XExpression implicitReturn) {
                if (method.getExpression() == implicitReturn) {
                    return;
                }
                XtendValidator.this.addIssue("Implicit return", (EObject)implicitReturn, "org.eclipse.xtend.core.validation.IssueCodes.implicit_return");
            }
        });
    }

    protected boolean isLocalClassSemantics(EObject object) {
        return super.isLocalClassSemantics(object) || object instanceof XtendMember && !(object instanceof AnonymousClass);
    }

    public void checkDeprecated(XImportDeclaration decl) {
        XtendFile file = (XtendFile)EcoreUtil2.getContainerOfType((EObject)decl, XtendFile.class);
        if (file != null) {
            for (XtendTypeDeclaration t : file.getXtendTypes()) {
                for (EObject e : this.jvmModelAssociations.getJvmElements((EObject)t)) {
                    if (!(e instanceof JvmAnnotationTarget) || !DeprecationUtil.isDeprecated((JvmAnnotationTarget)((JvmAnnotationTarget)e))) continue;
                    return;
                }
                if (!this.hasAnnotation(t, Deprecated.class)) continue;
                return;
            }
        }
        super.checkDeprecated(decl);
    }

    @Check
    public void checkTernaryExpressionUsed(XIfExpression exp) {
        if (exp.isConditionalExpression()) {
            EObject container = exp.eContainer();
            if (container instanceof XIfExpression && ((XIfExpression)container).isConditionalExpression()) {
                return;
            }
            this.addIssue("The ternary operator is not allowed. Use a normal if-expression.", (EObject)exp, "org.eclipse.xtend.core.validation.IssueCodes.ternary_if_operator_is_not_allowed");
        }
    }

    protected void addIssue(String message, EObject source, EStructuralFeature feature, int index, String issueCode, String ... issueData) {
        super.addIssue(message, source, feature, index, issueCode, issueData);
    }
}

