/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.threadgroups;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaThreadGroup;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaElementContentProvider;

public class JavaThreadGroupContentProvider
extends JavaElementContentProvider {
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        IJavaThreadGroup group;
        int count = 0;
        if (element instanceof IJavaThreadGroup && this.isAvailable(group = (IJavaThreadGroup)element)) {
            count += group.getThreadGroups().length;
            count += group.getThreads().length;
        }
        return count;
    }

    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if (parent instanceof IJavaThreadGroup) {
            return this.getElements(this.getChildren((IJavaThreadGroup)parent), index, length);
        }
        return EMPTY;
    }

    protected Object[] getChildren(IJavaThreadGroup group) throws CoreException {
        if (this.isAvailable(group)) {
            IJavaThreadGroup[] threadGroups = group.getThreadGroups();
            IJavaThread[] threads = group.getThreads();
            Object[] kids = new Object[threadGroups.length + threads.length];
            int index = 0;
            IJavaThread[] iJavaThreadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaThread thread = iJavaThreadArray[n2];
                kids[index] = thread;
                ++index;
                ++n2;
            }
            iJavaThreadArray = threadGroups;
            n = threadGroups.length;
            n2 = 0;
            while (n2 < n) {
                IJavaThread threadGroup = iJavaThreadArray[n2];
                kids[index] = threadGroup;
                ++index;
                ++n2;
            }
            return kids;
        }
        return EMPTY;
    }

    protected boolean isAvailable(IJavaThreadGroup group) {
        IDebugTarget debugTarget = group.getDebugTarget();
        return !debugTarget.isTerminated() && !debugTarget.isDisconnected();
    }
}

