/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteDrawer
extends PaletteContainer {
    public static final Object PALETTE_TYPE_DRAWER = "$Palette Drawer";
    public static final String PROPERTY_INITIAL_STATUS = "Initial status";
    public static final int INITIAL_STATE_OPEN = 0;
    public static final int INITIAL_STATE_CLOSED = 1;
    public static final int INITIAL_STATE_PINNED_OPEN = 2;
    @Deprecated
    public static final int INITIAL_STATUS_PINNED_OPEN = 2;
    private int initialState;
    private Object drawerType;
    private boolean showDefaultIcon = true;

    public PaletteDrawer(String label) {
        this(label, (ImageDescriptor)null);
    }

    public PaletteDrawer(String label, ImageDescriptor icon) {
        super(label, null, icon, PALETTE_TYPE_DRAWER);
        this.setUserModificationPermission(7);
    }

    @Override
    public boolean acceptsType(Object type) {
        if (type.equals(PALETTE_TYPE_DRAWER) || type.equals("Palette_Group")) {
            return false;
        }
        return super.acceptsType(type);
    }

    public Object getDrawerType() {
        if (this.drawerType != null) {
            return this.drawerType;
        }
        for (PaletteEntry child : this.children) {
            Object type = child.getType();
            if (type == PaletteSeparator.PALETTE_TYPE_SEPARATOR) continue;
            return type;
        }
        return "Palette_type_Unknown";
    }

    public int getInitialState() {
        return this.initialState;
    }

    public boolean isInitiallyOpen() {
        return this.getInitialState() == 0 || this.getInitialState() == 2;
    }

    public boolean isInitiallyPinned() {
        return this.getInitialState() == 2;
    }

    public void setDrawerType(Object obj) {
        this.drawerType = obj;
    }

    public void setInitialState(int state) {
        if (this.initialState == state) {
            return;
        }
        int oldState = this.initialState;
        this.initialState = state;
        this.listeners.firePropertyChange(PROPERTY_INITIAL_STATUS, oldState, state);
    }

    public boolean showDefaultIcon() {
        return this.showDefaultIcon;
    }

    public void setShowDefaultIcon(boolean showDefaultIcon) {
        this.showDefaultIcon = showDefaultIcon;
    }
}

