/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.service;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.search.SearchProgressMonitor;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class SearchStateService
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String STATE = "state";
    private static final String PERCENT = "percent";

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    private void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.setCharacterEncoding("UTF-8");
        int indexCompletion = 0;
        String locale = UrlUtil.getLocale(req, resp);
        SearchProgressMonitor pm = SearchProgressMonitor.getProgressMonitor((String)locale);
        if (pm.isDone()) {
            indexCompletion = 100;
        } else {
            indexCompletion = pm.getPercentage();
            if (indexCompletion >= 100) {
                indexCompletion = 99;
            }
        }
        String returnType = req.getParameter("returnType");
        boolean isXML = "xml".equalsIgnoreCase(returnType);
        PrintWriter writer = resp.getWriter();
        if (isXML) {
            resp.setContentType("application/xml");
            writer.write(SearchStateService.toXML(indexCompletion));
        } else {
            resp.setContentType("text/plain");
            writer.write(SearchStateService.toString(indexCompletion));
        }
        writer.flush();
    }

    public static String toXML(int percent) {
        Object xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = (String)xml + "<state>\n";
        xml = (String)xml + "\t<percent>" + percent + "</percent>\n";
        xml = (String)xml + "</state>";
        return xml;
    }

    public static String toString(int percent) {
        return "Percent:" + percent;
    }
}

