/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.artifact.repository.metadata;

/**
 * Versioning information for a sub-artifact of the current
 * snapshot artifact.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class SnapshotVersion
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The classifier of the sub-artifact. Each classifier and
     * extension pair may only appear once.
     */
    private String classifier = "";

    /**
     * The file extension of the sub-artifact. Each classifier and
     * extension pair may only appear once.
     */
    private String extension;

    /**
     * The resolved snapshot version of the sub-artifact.
     */
    private String version;

    /**
     * The timestamp when this version information was last
     * updated. The timestamp is expressed using UTC in the format
     * yyyyMMddHHmmss.
     */
    private String updated;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method clone.
     * 
     * @return SnapshotVersion
     */
    public SnapshotVersion clone()
    {
        try
        {
            SnapshotVersion copy = (SnapshotVersion) super.clone();

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- SnapshotVersion clone()

    /**
     * Method equals.
     * 
     * @param other a other object.
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof SnapshotVersion ) )
        {
            return false;
        }

        SnapshotVersion that = (SnapshotVersion) other;
        boolean result = true;

        result = result && ( getClassifier() == null ? that.getClassifier() == null : getClassifier().equals( that.getClassifier() ) );
        result = result && ( getExtension() == null ? that.getExtension() == null : getExtension().equals( that.getExtension() ) );
        result = result && ( getVersion() == null ? that.getVersion() == null : getVersion().equals( that.getVersion() ) );
        result = result && ( getUpdated() == null ? that.getUpdated() == null : getUpdated().equals( that.getUpdated() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get the classifier of the sub-artifact. Each classifier and
     * extension pair may only appear once.
     * 
     * @return String
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier()

    /**
     * Get the file extension of the sub-artifact. Each classifier
     * and extension pair may only appear once.
     * 
     * @return String
     */
    public String getExtension()
    {
        return this.extension;
    } //-- String getExtension()

    /**
     * Get the timestamp when this version information was last
     * updated. The timestamp is expressed using UTC in the format
     * yyyyMMddHHmmss.
     * 
     * @return String
     */
    public String getUpdated()
    {
        return this.updated;
    } //-- String getUpdated()

    /**
     * Get the resolved snapshot version of the sub-artifact.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( classifier != null ? classifier.hashCode() : 0 );
        result = 37 * result + ( extension != null ? extension.hashCode() : 0 );
        result = 37 * result + ( version != null ? version.hashCode() : 0 );
        result = 37 * result + ( updated != null ? updated.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set the classifier of the sub-artifact. Each classifier and
     * extension pair may only appear once.
     * 
     * @param classifier a classifier object.
     */
    public void setClassifier( String classifier )
    {
        this.classifier = classifier;
    } //-- void setClassifier( String )

    /**
     * Set the file extension of the sub-artifact. Each classifier
     * and extension pair may only appear once.
     * 
     * @param extension a extension object.
     */
    public void setExtension( String extension )
    {
        this.extension = extension;
    } //-- void setExtension( String )

    /**
     * Set the timestamp when this version information was last
     * updated. The timestamp is expressed using UTC in the format
     * yyyyMMddHHmmss.
     * 
     * @param updated a updated object.
     */
    public void setUpdated( String updated )
    {
        this.updated = updated;
    } //-- void setUpdated( String )

    /**
     * Set the resolved snapshot version of the sub-artifact.
     * 
     * @param version a version object.
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuilder buf = new StringBuilder( 128 );

        buf.append( "classifier = '" );
        buf.append( getClassifier() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "extension = '" );
        buf.append( getExtension() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "version = '" );
        buf.append( getVersion() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "updated = '" );
        buf.append( getUpdated() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()

}
