/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationImportInfo;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.s.nls.TranslationValidator;
import org.eclipse.scout.sdk.core.s.nls.manager.IStackedTranslation;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class TranslationImporter
implements ITranslationImportInfo {
    private final TranslationManager m_manager;
    private final List<List<String>> m_rawTableData;
    private final ITranslationStore m_storeForNewTranslations;
    private final String m_keyColumnName;
    private final Map<Integer, Language> m_columnMapping;
    private int m_keyColumnIndex;
    private int m_defaultLanguageColumnIndex;
    private final Map<Integer, String> m_unmappedColumns;
    private final Set<String> m_duplicateKeys;
    private final List<Integer> m_invalidRows;
    private final Map<String, IStackedTranslation> m_importedTranslations;
    private int m_result;

    protected TranslationImporter(TranslationManager managerToImportTo, List<List<String>> rawTableData, String keyColumnName, ITranslationStore storeForNewTranslations) {
        this.m_manager = (TranslationManager)Ensure.notNull((Object)managerToImportTo);
        this.m_rawTableData = (List)Ensure.notNull(rawTableData);
        this.m_storeForNewTranslations = storeForNewTranslations;
        this.m_keyColumnName = (String)Ensure.notBlank((CharSequence)keyColumnName);
        this.m_columnMapping = new HashMap<Integer, Language>();
        this.m_keyColumnIndex = -1;
        this.m_defaultLanguageColumnIndex = -1;
        this.m_unmappedColumns = new LinkedHashMap<Integer, String>();
        this.m_duplicateKeys = new HashSet<String>();
        this.m_invalidRows = new ArrayList<Integer>();
        this.m_importedTranslations = new HashMap<String, IStackedTranslation>();
    }

    public void tryImport() {
        this.m_result = this.doImport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doImport() {
        List<List<String>> rawData = this.rawTableData();
        if (rawData.size() < 2) {
            return 0;
        }
        HashMap toImport = new HashMap(rawData.size() - 1);
        this.m_duplicateKeys.addAll(IntStream.range(0, rawData.size()).mapToObj(row -> this.parseRow((List)rawData.get(row), row)).filter(Objects::nonNull).map(translation -> toImport.put(translation.key(), translation)).filter(Objects::nonNull).map(ITranslation::key).collect(Collectors.toSet()));
        if (!TranslationImporter.isValidHeader(this.keyColumnIndex(), this.defaultLanguageColumnIndex())) {
            return -1;
        }
        if (toImport.isEmpty()) {
            return 0;
        }
        TranslationManager manager = this.translationManager();
        ITranslationStore targetForNewTranslations = this.storeForNewTranslations();
        manager.setChanging(true);
        try {
            this.m_importedTranslations.putAll(toImport.values().stream().map(translation -> manager.mergeTranslation((ITranslation)translation, targetForNewTranslations)).collect(Collectors.toMap(ITranslation::key, Function.identity(), Ensure::failOnDuplicates)));
        }
        finally {
            manager.setChanging(false);
        }
        return this.importedTranslations().size();
    }

    protected ITranslation parseRow(List<String> row, int rowIndex) {
        if (!this.columnMappingDone()) {
            this.parseHeader(row);
            return null;
        }
        if (TranslationImporter.isEmptyRow(row)) {
            return null;
        }
        if (row.size() <= this.keyColumnIndex()) {
            this.m_invalidRows.add(rowIndex);
            return null;
        }
        String key = row.get(this.keyColumnIndex());
        if (TranslationValidator.isForbidden(TranslationValidator.validateKey(key))) {
            this.m_invalidRows.add(rowIndex);
            return null;
        }
        if (row.size() <= this.defaultLanguageColumnIndex()) {
            this.m_invalidRows.add(rowIndex);
            return null;
        }
        String defaultLangText = row.get(this.defaultLanguageColumnIndex());
        if (TranslationValidator.isForbidden(TranslationValidator.validateDefaultText(defaultLangText, key, this.translationManager(), null))) {
            this.m_invalidRows.add(rowIndex);
            return null;
        }
        Translation t = new Translation(key);
        t.putText(Language.LANGUAGE_DEFAULT, defaultLangText);
        this.m_columnMapping.forEach((index, language) -> TranslationImporter.appendText(t, language, row, index));
        return t;
    }

    protected static boolean isEmptyRow(Collection<String> row) {
        return row.stream().noneMatch(Strings::hasText);
    }

    protected static void appendText(Translation toFill, Language lang, List<String> row, int index) {
        if (row.size() <= index) {
            return;
        }
        String text = row.get(index);
        if (Strings.isEmpty((CharSequence)text)) {
            return;
        }
        toFill.putText(lang, text);
    }

    protected boolean isEmptyColumn(int columnIndex) {
        return this.rawTableData().stream().allMatch(row -> {
            if (columnIndex >= row.size()) {
                return true;
            }
            return Strings.isBlank((CharSequence)((CharSequence)row.get(columnIndex)));
        });
    }

    protected void parseHeader(List<String> headerRow) {
        HashMap<Integer, Language> columnMapping = new HashMap<Integer, Language>(headerRow.size() - 1);
        LinkedHashMap<Integer, String> unmappedColumns = new LinkedHashMap<Integer, String>();
        int keyColumnIndex = -1;
        int defaultLanguageColumnIndex = -1;
        for (int i = 0; i < headerRow.size(); ++i) {
            String cell = headerRow.get(i);
            if (Strings.isBlank((CharSequence)cell)) {
                if (this.isEmptyColumn(i)) continue;
                unmappedColumns.put(i, cell);
                continue;
            }
            if (this.keyColumnName().equalsIgnoreCase(cell)) {
                keyColumnIndex = i;
                continue;
            }
            if (Language.LANGUAGE_DEFAULT.locale().toString().equalsIgnoreCase(cell)) {
                defaultLanguageColumnIndex = i;
                continue;
            }
            Optional<Language> language = Language.parse(cell);
            if (language.isPresent()) {
                columnMapping.put(i, language.orElseThrow());
                continue;
            }
            unmappedColumns.put(i, cell);
        }
        if (TranslationImporter.isValidHeader(keyColumnIndex, defaultLanguageColumnIndex)) {
            this.m_columnMapping.putAll(columnMapping);
            this.m_unmappedColumns.putAll(unmappedColumns);
            this.m_keyColumnIndex = keyColumnIndex;
            this.m_defaultLanguageColumnIndex = defaultLanguageColumnIndex;
        }
    }

    @Override
    public Map<String, IStackedTranslation> importedTranslations() {
        return Collections.unmodifiableMap(this.m_importedTranslations);
    }

    @Override
    public int result() {
        return this.m_result;
    }

    @Override
    public int defaultLanguageColumnIndex() {
        return this.m_defaultLanguageColumnIndex;
    }

    @Override
    public int keyColumnIndex() {
        return this.m_keyColumnIndex;
    }

    @Override
    public Map<Integer, String> ignoredColumns() {
        return Collections.unmodifiableMap(this.m_unmappedColumns);
    }

    @Override
    public Set<String> duplicateKeys() {
        return Collections.unmodifiableSet(this.m_duplicateKeys);
    }

    @Override
    public List<Integer> invalidRowIndices() {
        return Collections.unmodifiableList(this.m_invalidRows);
    }

    protected boolean columnMappingDone() {
        return TranslationImporter.isValidHeader(this.keyColumnIndex(), this.defaultLanguageColumnIndex());
    }

    public String keyColumnName() {
        return this.m_keyColumnName;
    }

    public TranslationManager translationManager() {
        return this.m_manager;
    }

    public List<List<String>> rawTableData() {
        return this.m_rawTableData;
    }

    public ITranslationStore storeForNewTranslations() {
        return this.m_storeForNewTranslations;
    }

    protected static boolean isValidHeader(int keyColumnIndex, int defaultLanguageColumnIndex) {
        return TranslationImporter.isValidKeyColumnIndex(keyColumnIndex) && TranslationImporter.isValidDefaultLanguageColumnIndex(defaultLanguageColumnIndex);
    }

    protected static boolean isValidDefaultLanguageColumnIndex(int defaultLanguageColumnIndex) {
        return defaultLanguageColumnIndex >= 0;
    }

    protected static boolean isValidKeyColumnIndex(int keyColumnIndex) {
        return keyColumnIndex >= 0;
    }
}

