/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;

public class JavaSearchPattern
extends SearchPattern
implements IIndexConstants {
    boolean isCaseSensitive;
    boolean isCamelCase;
    int matchMode;
    int matchCompatibility;
    public static final int MATCH_MODE_MASK = 7;
    public static final int MATCH_COMPATIBILITY_MASK = 112;
    char[][] typeSignatures;
    private char[][][] typeArguments;
    private int flags = 0;
    static final int HAS_TYPE_ARGUMENTS = 1;

    protected JavaSearchPattern(int patternKind, int matchRule) {
        super(matchRule);
        this.kind = patternKind;
        int rule = this.getMatchRule();
        this.isCaseSensitive = (rule & 8) != 0;
        this.isCamelCase = (rule & 0x80) != 0;
        this.matchCompatibility = rule & 0x70;
        this.matchMode = rule & 7;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return null;
    }

    int getMatchMode() {
        return this.matchMode;
    }

    boolean isCamelCase() {
        return this.isCamelCase;
    }

    boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    boolean isErasureMatch() {
        return (this.matchCompatibility & 0x10) != 0;
    }

    boolean isEquivalentMatch() {
        return (this.matchCompatibility & 0x20) != 0;
    }

    char[][] extractMethodArguments(IFunction method) {
        return null;
    }

    final char[][][] getTypeArguments() {
        return this.typeArguments;
    }

    public final boolean hasSignatures() {
        return this.typeSignatures != null && this.typeSignatures.length > 0;
    }

    public final boolean hasTypeArguments() {
        return (this.flags & 1) != 0;
    }

    public final boolean hasTypeParameters() {
        return !this.hasSignatures() && this.hasTypeArguments();
    }

    boolean matchDifferentTypeSuffixes(int typeSuffix, int patternSuffix) {
        switch (typeSuffix) {
            case 67: {
                return false;
            }
        }
        return true;
    }

    protected StringBuffer print(StringBuffer output) {
        output.append(", ");
        if (this.hasTypeArguments() && this.hasSignatures()) {
            output.append("signature:\"");
            output.append(this.typeSignatures[0]);
            output.append("\", ");
        }
        if (this.isCamelCase) {
            output.append("camel case + ");
        }
        switch (this.getMatchMode()) {
            case 0: {
                output.append("exact match,");
                break;
            }
            case 1: {
                output.append("prefix match,");
                break;
            }
            case 2: {
                output.append("pattern match,");
                break;
            }
            case 4: {
                output.append("regexp match, ");
            }
        }
        if (this.isCaseSensitive()) {
            output.append(" case sensitive");
        } else {
            output.append(" case insensitive");
        }
        if ((this.matchCompatibility & 0x10) != 0) {
            output.append(", erasure only");
        }
        if ((this.matchCompatibility & 0x20) != 0) {
            output.append(", equivalent oronly");
        }
        return output;
    }

    final void setTypeArguments(char[][][] typeArguments) {
        this.typeArguments = typeArguments;
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            int i = 0;
            while (i < length) {
                if (this.typeArguments[i] != null && this.typeArguments[i].length > 0) {
                    this.flags |= 1;
                    break;
                }
                ++i;
            }
        }
    }

    void storeTypeSignaturesAndArguments(IType type) {
        char[][][] typeParameters = new char[10][][];
        int ptr = -1;
        boolean hasParameters = false;
        IJavaScriptElement parent = type;
        while (parent != null && parent.getElementType() == 7) {
            if (++ptr > typeParameters.length) {
                char[][][] cArrayArray = typeParameters;
                typeParameters = new char[typeParameters.length + 10][][];
                System.arraycopy(cArrayArray, 0, typeParameters, 0, ptr);
            }
            parent = parent.getParent();
        }
        if (hasParameters) {
            if (++ptr < typeParameters.length) {
                char[][][] cArrayArray = typeParameters;
                typeParameters = new char[ptr][][];
                System.arraycopy(cArrayArray, 0, typeParameters, 0, ptr);
            }
            this.setTypeArguments(typeParameters);
        }
    }

    @Override
    public final String toString() {
        return this.print(new StringBuffer(30)).toString();
    }
}

