/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.logger.proxy;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.jem.util.logger.proxy.ILogRenderer;
import org.eclipse.jem.util.logger.proxy.ILogRenderer2;
import org.eclipse.jem.util.logger.proxy.JDKConsoleRenderer;

public class Logger {
    private boolean fTraceMode = false;
    private String fPluginID;
    private ILogRenderer fRenderer = null;
    private ILogRenderer2 renderer2 = null;
    public String fLineSeperator;
    private Level level;
    private Level defaultLevel = Level.SEVERE;
    private String logFileName;
    private static final String DefaultLoggerPlugin = "org.eclipse.jem.util";
    private static Hashtable Loggers = new Hashtable();
    protected static final String[] LogMark = new String[]{"*** ERROR *** ", "[Trace] ", "+++ Warning +++ ", "Info "};
    protected static final String Filler = "    ";
    private static final Level[] LEVEL_SEARCH = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, ILogRenderer2.TRACE};
    private static final String[] LEVEL_MARK = new String[]{"*** ERROR ***", "+++ Warning +++", "Info", "[Trace]"};

    protected Logger() {
        this(DefaultLoggerPlugin);
    }

    protected Logger(String pluginID) {
        this.fPluginID = pluginID;
        this.setRenderer(new JDKConsoleRenderer(this));
    }

    public String exceptionToString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static Logger getLogger() {
        Logger defaultLogger = (Logger)Loggers.get(DefaultLoggerPlugin);
        if (defaultLogger == null) {
            defaultLogger = new Logger();
            defaultLogger.init();
            Loggers.put(DefaultLoggerPlugin, defaultLogger);
        }
        return defaultLogger;
    }

    public static Logger getLogger(String pluginId) {
        if (pluginId == null) {
            return Logger.getLogger();
        }
        Logger Logger2 = (Logger)Loggers.get(pluginId);
        if (Logger2 == null) {
            Logger2 = new Logger(pluginId);
            Logger2.init();
            Loggers.put(pluginId, Logger2);
        }
        return Logger2;
    }

    protected static Logger getLoggerIfExists(String pluginId) {
        if (pluginId == null) {
            return Logger.getLogger();
        }
        return (Logger)Loggers.get(pluginId);
    }

    public String getPluginID() {
        return this.fPluginID;
    }

    public boolean getTraceMode() {
        return this.fTraceMode;
    }

    private void indentMsg(String msg, StringBuffer logMsg) {
        String sep = this.fLineSeperator;
        if (msg.indexOf("\r\n") != -1) {
            sep = "\r\n";
        } else if (msg.indexOf("\n") != -1) {
            sep = "\n";
        } else if (msg.indexOf("\r") != -1) {
            sep = "\r";
        }
        StringTokenizer tokenizer = new StringTokenizer(msg, sep);
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            if (first) {
                first = false;
                logMsg.append(Filler + tokenizer.nextToken());
                continue;
            }
            logMsg.append(this.fLineSeperator + Filler + tokenizer.nextToken());
        }
    }

    private void init() {
        if (System.getProperty("debug") != null) {
            this.fTraceMode = true;
        }
        this.level = this.defaultLevel = Level.parse(System.getProperty("logLevel", Level.WARNING.getName()));
        try {
            this.fLineSeperator = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            this.fLineSeperator = "\n";
        }
    }

    private String logAny(String msg, int type) {
        StringBuffer logMsg = new StringBuffer();
        logMsg.append(this.fLineSeperator);
        logMsg.append(LogMark[type]);
        return this.punchLog(this.logRest(msg, logMsg), type);
    }

    public String getGenericMsg(String msg, Level aLevel) {
        StringBuffer genMsg = new StringBuffer(msg.length() + 16);
        genMsg.append(this.fLineSeperator);
        genMsg.append(this.getLevelHeader(aLevel));
        genMsg.append(": ");
        genMsg.append(new Date());
        this.indentMsg(msg, genMsg);
        return genMsg.toString();
    }

    private String getLevelHeader(Level aLevel) {
        int i = 0;
        while (i < LEVEL_SEARCH.length) {
            if (LEVEL_SEARCH[i] == aLevel) {
                return LEVEL_MARK[i];
            }
            ++i;
        }
        return aLevel.getName();
    }

    public String write(Level aLevel, Exception ex) {
        return this.log(aLevel, ex);
    }

    public String write(Throwable ex) {
        return this.log(ex);
    }

    public String write(Level aLevel, Object logEntry) {
        return this.log(logEntry, aLevel);
    }

    public String write(Level aLevel, String string) {
        return this.log(string, aLevel);
    }

    public String write(Level aLevel, Throwable ex) {
        return this.log(ex, aLevel);
    }

    public String log(Level aLevel, Exception ex) {
        return this.log(ex, aLevel);
    }

    public String log(Level aLevel, Throwable ex) {
        return this.log(ex, aLevel);
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isLoggingLevel(Level requestlevel) {
        if (requestlevel == ILogRenderer2.TRACE && !this.getTraceMode()) {
            return false;
        }
        return requestlevel.intValue() >= this.getLevel().intValue() && this.getLevel() != Level.OFF;
    }

    public String logError(String msg) {
        return this.log(msg, Level.SEVERE);
    }

    public String logError(Throwable e) {
        return this.log(e, Level.SEVERE);
    }

    public String logInfo(String msg) {
        return this.log(msg, Level.INFO);
    }

    public String logInfo(Throwable e) {
        return this.log(e, Level.INFO);
    }

    protected String logRest(String msg, StringBuffer logMsg) {
        logMsg.append(new Date());
        this.indentMsg(msg, logMsg);
        return logMsg.toString();
    }

    public String logTrace(String msg) {
        if (this.fTraceMode) {
            return this.log(msg, ILogRenderer2.TRACE);
        }
        return "";
    }

    public String logTrace(Throwable e) {
        return this.log(e, ILogRenderer2.TRACE);
    }

    public String logWarning(String msg) {
        return this.log(msg, Level.WARNING);
    }

    public String logWarning(Throwable e) {
        return this.log(e, Level.WARNING);
    }

    protected synchronized String punchLog(String msg, int type) {
        return this.fRenderer.log(msg, type);
    }

    public void setRenderer(ILogRenderer renderer) {
        this.fRenderer = renderer;
        this.renderer2 = renderer instanceof ILogRenderer2 ? (ILogRenderer2)renderer : null;
        renderer.setTraceMode(this.getTraceMode());
    }

    public void setTraceMode(boolean flag) {
        this.fTraceMode = flag;
        if (this.fRenderer != null) {
            this.fRenderer.setTraceMode(flag);
        }
    }

    public void setLevel(Level level) {
        this.level = level != ILogRenderer2.DEFAULT ? level : this.defaultLevel;
    }

    public void setDefaultLevel(Level level) {
        this.defaultLevel = level;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public String log(Throwable e) {
        return this.log(e, ILogRenderer2.DEFAULT);
    }

    public String log(Throwable e, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(e, logLevel);
        }
        String stackTrace = this.exceptionToString(e);
        return this.logAny(stackTrace, this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.SEVERE));
    }

    public String log(Object o) {
        return this.log(o, ILogRenderer2.DEFAULT);
    }

    public String log(Object o, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(o, logLevel);
        }
        return this.logAny(String.valueOf(o), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    public String log(boolean b) {
        return this.log(b, ILogRenderer2.DEFAULT);
    }

    public String log(boolean b, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(b, logLevel);
        }
        return this.logAny(String.valueOf(b), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    public String log(char c) {
        return this.log(c, ILogRenderer2.DEFAULT);
    }

    public String log(char c, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(c, logLevel);
        }
        return this.logAny(String.valueOf(c), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    public String log(byte b) {
        return this.log(b, ILogRenderer2.DEFAULT);
    }

    public String log(byte b, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(b, logLevel);
        }
        return this.logAny(String.valueOf(b), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    public String log(short s) {
        return this.log(s, ILogRenderer2.DEFAULT);
    }

    public String log(short s, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(s, logLevel);
        }
        return this.logAny(String.valueOf(s), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    public String log(int i) {
        return this.log(i, ILogRenderer2.DEFAULT);
    }

    public String log(int i, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(i, logLevel);
        }
        return this.logAny(String.valueOf(i), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    public String log(long l) {
        return this.log(l, ILogRenderer2.DEFAULT);
    }

    public String log(long l, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(l, logLevel);
        }
        return this.logAny(String.valueOf(l), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    public String log(float f) {
        return this.log(f, ILogRenderer2.DEFAULT);
    }

    public String log(float f, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(f, logLevel);
        }
        return this.logAny(String.valueOf(f), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    public String log(double d) {
        return this.log(d, ILogRenderer2.DEFAULT);
    }

    public String log(double d, Level logLevel) {
        if (this.renderer2 != null) {
            return this.renderer2.log(d, logLevel);
        }
        return this.logAny(String.valueOf(d), this.getOldType(logLevel != ILogRenderer2.DEFAULT ? this.level : Level.FINEST));
    }

    private int getOldType(Level aLevel) {
        if (aLevel == Level.SEVERE) {
            return 0;
        }
        if (aLevel == Level.WARNING) {
            return 2;
        }
        if (aLevel == Level.INFO) {
            return 3;
        }
        if (aLevel == ILogRenderer2.TRACE) {
            return 1;
        }
        return 3;
    }

    static class LocalLevel
    extends Level {
        private static final long serialVersionUID = -6273357074767854883L;

        public LocalLevel(String name, int level) {
            super(name, level);
        }
    }
}

